<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


use App\Models\FlightSSR;

class ParsePSM
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null, $partialParsing = null){

        // Match Title
        $pattern = '/.*PSM\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([0-9A-Z]{3})[\.\s]*([A-Z]{3})?(?:\sPART(\d+))/m';

        $try = preg_match_all($pattern, $parseText, $matchTitle);

        if ($try) {

            list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $departureAirport, $part) = $matchTitle;
            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
                "departureAirport"  => $departureAirport ? $departureAirport[0] : "",
                "part"              => $part ? $part[0] : null,
            ];

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck, $messageDetails["departureMonth"]);
            if (!$date){
                return false;
            }

            debug($messageDetails);

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);


            if (!$partialParsing) {
                // Match the Rest
                preg_match_all('/^1([\s\S]*?)(?=^1|^END|^Y CLASS|^C CLASS)/m', $parseText, $matches);

                $totalPax = [];
                foreach ($matches[0] as $each) {
                    debug($each);

                    preg_match_all('/^\s*1([A-Z]+)\/([A-Z]+\s*[A-Z]*\s*[A-Z]*)\s*(?:0*(\d+[A-Z]+))(?:\s*([A-Z0-9]{2})([A-Z0-9]+)([A-Z]{1})(\d{2})([A-Z]{3})(\d{4})?([A-Z]{2})?)?(?:\s*([A-Z]{3,4}))(?:\s*([A-Z]{3,4}))?(?:\s*HK1\s*(.*))?/m', $each, $match);

                    list($all, $lName, $fName, $seat, $oAirline, $oFltNo, $oRBD, $oDay, $oDest, $oDepTime, $oDepAirline, $ssr, $ssr2, $info) = $match;
                    $passengerDetails = [
                        "lastName" => $lName && isset($lName[0]) && $lName[0] ? trim($lName[0]) : null,
                        "firstName" => $fName && isset($fName[0]) && $fName[0] ? trim($fName[0]) : null,
                        "seat" => $seat && isset($seat[0]) && $seat[0] ? trim($seat[0]) : null,

                        "outbAirline" => $oAirline && isset($oAirline[0]) && $oAirline[0] ? trim($oAirline[0]) : null,
                        "outbFltNo" => $oFltNo && isset($oFltNo[0]) && $oFltNo[0] ? trim($oFltNo[0]) : null,
                        "outbRBD" => $oRBD && isset($oRBD[0]) && $oRBD[0] ? trim($oRBD[0]) : null,
                        "outbDay" => $oDay && isset($oDay[0]) && $oDay[0] ? trim($oDay[0]) : null,
                        "outbDest" => $oDest && isset($oDest[0]) && $oDest[0] ? trim($oDest[0]) : null,

                        "outbDeptTime" => $oDepTime && isset($oDepTime[0]) && $oDepTime[0] ? trim($oDepTime[0]) : null,
                        "outbDepAirline" => $oDepAirline && isset($oDepAirline[0]) && $oDepAirline[0] ? trim($oDepAirline[0]) : null,

                        "ssr" => $ssr && isset($ssr[0]) && $ssr[0] ? trim($ssr[0]) : null,
                        "ssr2" => $ssr2 && isset($ssr2[0]) && $ssr2[0] ? trim($ssr2[0]) : null,
                        "ssr_info" => $info && isset($info[0]) && $info[0] ? trim($info[0]) : null,
                    ];

                    debug($passengerDetails);

                    if (isset($passengerDetails["lastName"])) {

                        if ($passengerDetails["lastName"] == "C" && !$passengerDetails["firstName"]){
                            continue;
                        }

                        // Get gender
                        Parse::getPassengerGender($passengerDetails);

                        Parse::findPassengerProcess($passengerDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, true, PSM);

                        $totalPax[] = $passengerDetails;
                    }

                    debug($totalPax);
                }

            }

            // SSR
           $this->parse($flight, $parseText, $messageDetails["part"], true);

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }
        }

        return false;

    }

    public function parse($flight, $parseText, $messagePart = null, $deleteOtherSSRs = false){
        if ($flight && (!$messagePart || $messagePart == 1)){
            $sPattern = '/^(\w{3,4})(?:\s+(\d+)[J|C])?\s+(?:(\d+)[Y|M|B])/m';

            $sTry = preg_match_all($sPattern, $parseText, $sMatch);

            if ($sTry) {
                list($sAll, $ssrCodes, $paxCArray, $paxYArray) = $sMatch;
                $processedIDs = [];
                foreach ($ssrCodes as $i => $ssr) {

                    $paxC = isset($paxCArray[$i]) ? (int)$paxCArray[$i] : null;
                    $paxY = isset($paxYArray[$i]) ? (int)$paxYArray[$i] : null;

//                    debug($ssr." | $paxC | $paxY");
                    // Not Pax continue
                    if (!$paxC && !$paxY){
                        continue;
                    }

                    $findSSR = FlightSSR::firstOrCreate([
                        "flight_id"     => $flight->id,
                        "ssr"           => strtoupper($ssr),
                    ]);

                    $findSSR->pax_c = $paxC;
                    $findSSR->pax_y = $paxY;
                    $findSSR->save();

                    $processedIDs[] = $findSSR->id;
                }

                if ($deleteOtherSSRs) {
                    // Remove others
                    $deleteOthers = FlightSSR::where("flight_id", $flight->id);

                    if (count($processedIDs)) {
                        $deleteOthers->whereNotIn("id", $processedIDs);
                    }

//                    debug($deleteOthers->get()->pluck("id")->all());
                    $deleteOthers->delete();
                }
            }
        }
    }
}
