<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParsePRL
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null, $partialParsing = null){

        // Match Title
        $pattern = '/.*(?:PRL)\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([0-9A-Z]{3})[\.\s]*([A-Z]{3})?(?:\sPART(\d+))?(?:\s*CFG[\.\/](?:(\d+)C)?(?:(\d+)Y)?)?/m';

        $try = preg_match_all($pattern, $parseText, $matchTitle);

        if ($try) {
            list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $departureAirport, $part, $capacityC, $capacityY) = $matchTitle;
            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
                "departureAirport"  => $departureAirport ? $departureAirport[0] : "",
                "part"              => $part ? $part[0] : null,

                // Disabled on OCT/16/2019
//                "capacityC"         => $capacityC ? $capacityC[0] : null,
//                "capacityY"         => $capacityY ? $capacityY[0] : null,

//                "arrivalAirport"    => $arrivalAirport ? $arrivalAirport[0] : null,
//                "paxC_bkd"          => $paxCBkd ? $paxCBkd[0] : null,
//                "paxY_bkd"          => $paxYBkd ? $paxYBkd[0] : null,
            ];

            Parse::checkAndUpdateAirport($messageDetails);

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck, $messageDetails["departureMonth"]);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            if (!$partialParsing) {
                preg_match_all('/(?:-(\w{3})[\/]?(?:(\d+)[C|J])?(?:(\d+)Y)?)([\s\S]+?(?=^-|^ENDPA?RL?T?))/m', $parseText, $matchesClasses);

                $allPassengers = [];

                if (isset($matchesClasses[0])) {

                    foreach ($matchesClasses[0] as $matchClass) {

                        preg_match_all('/^\s*1.*(?:\s*\.[ROILWN][N2]?\/.*)*/m', $matchClass, $matches);

                        debug($matches);

                        foreach ($matches[0] as $each) {

                            preg_match_all('/^\s*1([A-Z]+)\/([A-Z]+)(?:[-]([A-Z]{1,2}\d{1,2}))?/m', $each, $match);

                            // list($all, $lastName, $firstName, $group_tcp, $isInf, $parentLastName, $parentFirstName, $ticketNumber, $coupon, $pnr1, $seat, $pnr2) = $match;

                            list($all, $lastName, $firstName, $groupTCP) = $match;
                            $passengerDetails = [
                                "lastName" => $lastName && isset($lastName[0]) && $lastName[0] ? $lastName[0] : null,
                                "firstName" => $firstName && isset($firstName[0]) && $firstName[0] ? $firstName[0] : null,
                                "groupTcp" => $groupTCP && isset($groupTCP[0]) && $groupTCP[0] ? $groupTCP[0] : null,
                            ];

                            if (!$passengerDetails["groupTcp"]) {
                                unset($passengerDetails["groupTcp"]);
                            }

                            $patternDetails = '/(?:(\.[ROILWN]N?\/.*?)(?=\s*\.[ROILWN]N?\/))|(\.[ROILWN]N?\/.*)/m';
                            preg_match_all($patternDetails, $each, $matchDetails);

                            if (isset($matchDetails[0])) {
                                $patternEachRecord = '/(?:.R\/INFT.*?(\d{2}[A-Z]{3}\d{2})\s*([A-Z]+)\/([A-Z]+))|(?:.R\/(?:(?:ETLP)|(?:TKNE)).*?INF(\d{13})\/(\d{1,2}))|(?:.R\/(?:(?:ETLP)|(?:TKNE)).*?(\d{13})\/(\d{1,2}))|(?:.R\/FQTV\s*([A-Z0-9]{2})\s*([A-Z0-9]+))|(?:.R\/CHKD.*?SEQ(\d+))|(?:.R\/(?:(?:SEAT)|(?:RQST)).*?(\d{1,3}[A-Z]{1,2}))|(?:.L\/(\w{6}))|(?:.W\/K\/(\d+)\/(\d+))|(?:.N\/(.+))|(?:.O\/([A-Z0-9]{2})([A-Z0-9]+)([A-Z]{1})(\d{2})([A-Z]{3})(\d{4})?([A-Z]{2})?)|(?:.I\/([A-Z0-9]{2})([A-Z0-9]+)([A-Z]{1})(\d{2})([A-Z]{3})(\d{4})?([A-Z]{2})?)|(?:\.R\/XBAG.*?(?:(\d+)BAGS)?\s*(?:((?:PRE)?PAID))?\s*(?:(\d+)KG)\s*(.+))|(?:\.R\/DOCS\s*HK1\/(?:([A-Z]{1}))?\/(?:([A-Z]{2,3}))?\/(?:([A-Z0-9]+))?\/(?:([A-Z]{2,3}))?\/(\d{2}[A-Z]{3}\d{2})?\/(?:([A-Z]{1}))?\/(\d{2}[A-Z]{3}\d{2})?\/(\w+)?\/(\w+))|(?:.RN\/(.+))|(?:.R\/DOCA\s*HK1\/R\/(\w{3}))|(?:.R\/DOCA\s*HK1\/D\/+(.+))/';
                                foreach ($matchDetails[0] as $line) {
                                    preg_match($patternEachRecord, $line, $matchEachRecord);
                                    Parse::getPrlArrayRecord($passengerDetails, $matchEachRecord);
                                }
                            }

                            // Record somewhere that passenger doesn't have required Ticket Number
                            if (!isset($passengerDetails['ticketNumber']) || !$passengerDetails['ticketNumber']) {
                                if ($parseEmail) {
                                    $parseEmail->messageLog[] = "Ticket Number Not Found: \n" . $each . "\n";
                                }
                            }

                            if (!isset($passengerDetails['lastName']) || !$passengerDetails['lastName']) {
                                if ($parseEmail) {
                                    $parseEmail->messageLog[] = "Passenger Last Name Not Found. \n" .
                                        "Passenger Record Not Created. \n" .
                                        $each . "\n";
                                }
                            }

                            $allPassengers[] = $passengerDetails;


                            // Get gender
                            Parse::getPassengerGender($passengerDetails);

                            Parse::findPassengerProcess($passengerDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, TRUE, PRL);
                        }

                        debug($allPassengers);

                    }
                }
            }

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }
        }

        return false;

    }

}
