<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParsePNL
{
    public $parseOperations;

    public $ghaExceptionAirlinesList = ["U6", "EL"];

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null, $partialParsing = null){
        if ($this->parseOperations->airlineModule){
            $messageDetails = self::getFormat1($parseText);

            if (!$messageDetails){
                $messageDetails = self::getFormat2($parseText);
            }
        }
        else {
            $messageDetails = self::getFormatIATA($parseText);

            // Apply Format 1 parsing for GHA exceptional airlines list
            if (!$messageDetails || in_array($messageDetails['airline'], $this->ghaExceptionAirlinesList)){

                debug("EXCEPTION AIRLINES LIST");

                $messageDetails = self::getFormat1($parseText);
            }

            if (!$messageDetails){
                $messageDetails = self::getFormat2($parseText);
            }

        }

        if ($messageDetails) {

            debug($messageDetails);

            Parse::checkAndUpdateAirport($messageDetails);

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck, $messageDetails["departureMonth"]);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            debug($messageDetails);

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);


            // Match the Rest
            if (!$partialParsing){
                preg_match_all('/^\s*\d+.*(?:\s*\.(?:[CILM]|O2?|RN?)\/.*)*/m', $parseText, $matches);

                $totalPax = [];
                foreach ($matches[0] as $each) {

                    $passengers = null;

                    preg_match_all('/^\s*\d{1}([A-Z]+)\/([A-Z]+)(?:\/(.[^\.\-]*))?(?:[-]([A-Z]{1,2}\d{1,2}))?/m', $each, $match);

                    list($all, $lastName, $firstName, $otherFirstNames, $groupTCP) = $match;
                    $passenger = [
                        "lastName"          => $lastName   && isset($lastName[0])    && $lastName[0]        ? $lastName[0]         : null,
                        "firstName"         => $firstName  && isset($firstName[0])   && $firstName[0]       ? $firstName[0]        : null,
                        "groupTcp"          => $groupTCP   && isset($groupTCP[0])    && $groupTCP[0]        ? $groupTCP[0]         : null,
                    ];

                    $otherFirstNames = $otherFirstNames && isset($otherFirstNames[0]) && $otherFirstNames[0] ? $otherFirstNames[0]  : null;

                    // Set Gender
                    Parse::getPassengerGender($passenger);

                    $patternDetails = '/(?:(\.(?:[CILM]|O2?|RN?)\/.*?)(?=\s*\.(?:[CILM]|O2?|RN?)\/))|(\.(?:[CILM]|O2?|RN?)\/.*)/m';

                    preg_match_all($patternDetails, $each, $matchDetails);

                    if (isset($matchDetails[0]) && $matchDetails[0]){

                        $patternEachRecord = '/(?:.R\/INFT.*?(\d{2}[A-Z]{3}\d{2})\s*([A-Z]+)\/([A-Z]+))|(?:.R\/(?:(?:ETLP)|(?:TKNE)).*?INF(\d{13})\/(\d{1,2})(?:\-1([A-Z]+)\/([A-Z]+)(?=MR|MS|MRS|MISS|CHD))?)|(?:.R\/(?:(?:ETLP)|(?:TKNE)).*?(\d{13})\/(\d{1,2})(?:\-1([A-Z]+)\/([A-Z]+)(?=MR|MS|MRS|MISS|CHD))?)|(?:.R\/FQTV\s*([A-Z0-9]{2})\s*([A-Z0-9]+))|(?:.R\/CHKD.*?SEQ(\d+))|(?:.R\/(?:(?:SEAT)|(?:RQST)).*?(\d{1,3}[A-Z]{1,2})(?:\-1([A-Z]+)\/([A-Z]+)(?=MR|MS|MRS|MISS|CHD))?)|(?:\.L\/(\w+))|(?:.O\/([A-Z0-9]{2})([A-Z0-9]+)([A-Z]{1})(\d{2})([A-Z]{3})(\d{4})?([A-Z]{2})?)|(?:.I\/([A-Z0-9]{2})([A-Z0-9]+)([A-Z]{1})(\d{2})([A-Z]{3})(\d{4})?([A-Z]{2})?)|(?:\.R\/XBAG.*?(?:0*(\d+)BAGS)?\s*(?:((?:PRE)?PAID))?\s*(?:(?:(\d+)KG\s*(.+))|(?:0*(\d+)?BAGS\s*(\d+)))(?:\-1([A-Z]+)\/([A-Z]+)(?=MR|MS|MRS|MISS|CHD))?)|(?:\.R\/DOCS\s*HK1\/(?:([A-Z]{1}))?\/(?:([A-Z]{2,3}))?\/(?:([A-Z0-9\s]+))?\/(?:([A-Z]{2,3}))?\/(\d{2}[A-Z]{3}\d{2})?\/(?:([A-Z]{1}))?\/(\d{2}[A-Z]{3}\d{2})?(?:\/([A-Z]+)(?:\/([A-Z]+))?)?)|(?:\.R\/SPML\s*(?:HK1\s*)(\w+)(?:\-1([A-Z]+)\/([A-Z]+)(?=MR|MS|MRS|MISS|CHD))?)|(?:\.R\/EPAY\s*KK(\d+)\s*CC\/(\w{4}\-\w{4}\-\w{4}\-\w{4}))|(?:.O2\/([A-Z0-9]{2})([A-Z0-9]+)([A-Z]{1})(\d{2})([A-Z]{3})(\d{4})?([A-Z]{2})?)|(?:.M\/([A-Z0-9]{2})([A-Z0-9]+)([A-Z]{1})(\d{2})(?:([A-Z]{3})([A-Z]{3})?))/';

                        // MANY PAX
                        if ($otherFirstNames){

                            $otherFirstNames = explode("/", $otherFirstNames);

                            // First PAX
                            $passengers[] = $passenger;

                            foreach ($otherFirstNames as $fName) {

                                $pax = [
                                    "lastName"      => $passenger["lastName"],
                                    "firstName"     => $fName,
                                    "groupTcp"      => $passenger["groupTcp"],
                                ];

                                Parse::getPassengerGender($pax);

                                // Other PAX
                                $passengers[] = $pax;
                            }

                            $infRecord = null;
                            foreach ($matchDetails[0] as $line) {

                                $paxDetails = [];

                                preg_match($patternEachRecord, $line, $matchEachRecord);

                                Parse::getPnlArrayRecord($paxDetails, $matchEachRecord);

                                $searchLName = $searchFName = null;
                                foreach($paxDetails as $parameter => $value){

                                    if (contains($parameter, "LName")){
                                        $searchLName = $value;
                                    }
                                    if (contains($parameter, "FName")){
                                        $searchFName = $value;
                                    }

                                    if (in_array($parameter, ['infDOB', 'infLname', 'infFname'])){
                                        $infRecord[$parameter] = $value;
                                    }
                                }

                                if ($searchLName && $searchFName){
                                    $foundIndex = 0;
                                    foreach ($passengers as $i => $paxEach) {
                                        if ($paxEach['firstName'] == $searchFName){
                                            $foundIndex = $i;
                                            break;
                                        }
                                    }

                                    foreach($paxDetails as $parameter => $value){
                                        if (!contains($parameter, ["LName", "FName"])){
                                            $passengers[$foundIndex][$parameter] = $value;
                                        }
                                    }
                                }
                                else {
                                    foreach($paxDetails as $parameter => $value){
                                        // Processed below at -4-
                                        if (in_array($parameter, ['infDOB', 'infLname', 'infFname'])){
                                            continue;
                                        }
                                        // Parameters that applies to all passengers
                                        if (in_array($parameter, ["pnr"])){
                                            foreach ($passengers as $i => $pax ) {
                                                $passengers[$i][$parameter] = $value;
                                            }
                                        }
                                        // Not identified -> applies to first passenger
                                        else {
                                            $passengers[0][$parameter] = $value;
                                        }
                                    }
                                }
                            }

                            // -4-
                            if ($infRecord){
                                $foundIndex = 0;
                                foreach ($passengers as $i => $paxEach) {
                                    if (isset($paxEach['infTktNo']) && $paxEach['infTktNo']){
                                        $foundIndex = $i;
                                        break;
                                    }
                                }

                                foreach ($infRecord as $parameter => $value ) {
                                    $passengers[$foundIndex][$parameter] = $value;
                                }
                            }

                            foreach ($passengers as $pax) {

                                Parse::findPassengerProcess($pax, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, false, PNL);

                                $totalPax[] = $pax;

                            }
                        }
                        // 1 PAX
                        else {

                            foreach ($matchDetails[0] as $line) {

                                preg_match($patternEachRecord, $line, $matchEachRecord);

                                $passengerDetails = null;

                                Parse::getPnlArrayRecord($passengerDetails, $matchEachRecord);

                                if ($passengerDetails && is_array($passengerDetails)) {

                                    foreach ($passengerDetails as $parameter => $value) {

                                        if (!contains($parameter, ["LName", "FName"])) {
                                            $passenger[$parameter] = $value;
                                        }
                                    }
                                }
                            }

                            Parse::findPassengerProcess($passenger, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, false, PNL);

                            $totalPax[] = $passenger;
                        }
                    }
                }

                debug($totalPax);
            }

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }
        }

        return false;
    }

    function getFormatIATA($parseText){

        $pattern = '/.*(?:PNL)\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([0-9A-Z]{3})[\.\s]*([A-Z]{3})?(?:\sPART(\d+))?(?:\s*CFG[\.\/](?:(\d+)C)?(?:(\d+)Y)?)?(?:\s*RBD\s*[A-Z]{1}\/[A-Z]+)?(?:\s*-?\w{3}[\/]?(?:\d+C)?\d+[A-Z])*(?:\s*-?(\w{3})[\/]?(?:(\d+)C)?(\d+)Y)/m';

        $try = preg_match_all($pattern, $parseText, $matchTitle);

        if (!$try){
            return null;
        }

        //      0           1           2               3           4                      5           6
        list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $departureAirport, $part,
            //   7           8             9            10         11
            $capacityC, $capacityY, $arrivalAirport, $paxCBkd, $paxYBkd) = $matchTitle;

        $messageDetails = [
            "airline"           => $airline[0],
            "flightNumber"      => $flightNumber[0],
            "departureDay"      => $departureDay[0],
            "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
            "departureAirport"  => $departureAirport ? $departureAirport[0] : "",
            "part"              => $part ? $part[0] : null,

            // Disabled on OCT/16/2019
//            "capacityC"         => $capacityC ? $capacityC[0] : null,
//            "capacityY"         => $capacityY ? $capacityY[0] : null,

            "arrivalAirport"    => $arrivalAirport ? $arrivalAirport[0] : "",
            "paxC_bkd"          => $paxCBkd ? $paxCBkd[0] : null,
            "paxY_bkd"          => $paxYBkd ? $paxYBkd[0] : null,
        ];

        if ($messageDetails["departureAirport"] == "CFG"){
            $messageDetails["departureAirport"] = "";
        }
        if ($messageDetails["arrivalAirport"] == "CFG"){
            $messageDetails["arrivalAirport"] = "";
        }

        return $messageDetails;
    }

    function getFormat1($parseText){

        $pattern = '/.*(?:PNL)\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([0-9A-Z]{3})[\.\s]*([A-Z]{3})?(?:\sPART(\d+))?(?:\s*CFG[\.\/](?:(\d+)C)?(?:(\d+)Y)?)?[\s\S]*(?:AVAIL\s*(\w{3})\s*(\w{3}))/m';

        $try = preg_match_all($pattern, $parseText, $matchTitle);

        if (!$try){
            return null;
        }

        //      0           1           2               3           4                      5           6
        list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $departureAirport, $part,
            //  7           8             9            10         11
            $capacityC, $capacityY, $depAirport, $arrivalAirport) = $matchTitle;

        $messageDetails = [
            "airline"           => $airline[0],
            "flightNumber"      => $flightNumber[0],
            "departureDay"      => $departureDay[0],
            "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
            "departureAirport"  => $departureAirport ? $departureAirport[0] : ($depAirport ? $depAirport[0] : null),
            "part"              => $part ? $part[0] : null,

            // Disabled on OCT/16/2019
//            "capacityC"         => $capacityC ? $capacityC[0] : null,
//            "capacityY"         => $capacityY ? $capacityY[0] : null,

            "arrivalAirport"    => $arrivalAirport ? $arrivalAirport[0] : null,
        ];

        if ($messageDetails["departureAirport"] == "CFG"){
            $messageDetails["departureAirport"] = "";
        }
        if ($messageDetails["arrivalAirport"] == "CFG"){
            $messageDetails["arrivalAirport"] = "";
        }

        // ARR APP NOT APPLICABLE FOR AIRLINE MODULE
        if ($this->parseOperations->airlineModule){
            $messageDetails["arrivalAirport"] = null;
        }

        return $messageDetails;
    }

    function getFormat2($parseText){

        $pattern = '/.*(?:PNL)\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([0-9A-Z]{3})[\.\s]*([A-Z]{3})?(?:\sPART(\d+))?(?:[\s\S]*?-((?!CFG)[A-Z]{3}))/m';

        $try = preg_match_all($pattern, $parseText, $matchTitle);

        if (!$try){
            return null;
        }

        //      0           1           2               3           4                      5           6
        list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $departureAirport, $part,
            //     7
            $arrivalAirport) = $matchTitle;

        $messageDetails = [
            "airline"           => $airline[0],
            "flightNumber"      => $flightNumber[0],
            "departureDay"      => $departureDay[0],
            "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
            "departureAirport"  => $departureAirport ? $departureAirport[0] : null,
            "part"              => $part ? $part[0] : null,

            "arrivalAirport"    => $arrivalAirport ? $arrivalAirport[0] : null,
        ];

        // ARR APP NOT APPLICABLE FOR AIRLINE MODULE
        if ($this->parseOperations->airlineModule){
            $messageDetails["arrivalAirport"] = null;
        }

        return $messageDetails;
    }




}
