<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseOthers
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        if ( $this->parseOperations->messageType == TXT_ING){
            $pattern = '/.*TXT\/ING\s*(?:(?:[\s\S])*(?:\s([0-9A-Z]{2}[A-Z]?)\s*([0-9]{1,5}[A-Z]?)\s*\/\s*([0-9]{1,2})\s*\/\s*([0-9]{1,2})\s*\/\s*([0-9]{1,4})))/m';
        }
        else {
//            $pattern = '/.*(?:'.$messageType.')\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*(?:([0-9A-Za-z]{3})(?:[\.\s]))?(?:([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})(?:[\.\s]))?([A-Za-z]{3})?[\.\s]*(?:([A-Za-z]{3})(?:[\.\s]))?/m';
//            $pattern = '/.*(?:'.$messageType.')\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*(?:([0-9A-Za-z]{3})(?:[\.\s]))?(?:([A-Z0-9]{5})\s)?[\.\s]*(?:([A-Za-z]{3})\s)?[\.\s]*(?:([A-Za-z]{3})(?:[\.\s]))?/m';
//            $pattern = '/.*(?:'.$messageType.')\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*(?:([0-9A-Z]{3})[\.\s])?(?:([A-Z0-9]{5})[\.\s])?(?:([A-Z]{3})\s)?[\.\s]*(?:(?!OUT)([A-Z]{3})[\.\s])?/m';
            $pattern = '/^\s*(?:'.$this->parseOperations->messageType.')\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*(?:([0-9A-Z]{3})[\.\s])?(?:([A-Z0-9]{5})[\.\s])?(?:([A-Z]{3})\s)?[\.\s]*(?:(?!OUT)([A-Z]{3})[\.\s])?/m';
        }

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            if ($this->parseOperations->messageType == TXT_ING){
                list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $departureYear) = $matches;
                $messageDetails = [
                    "airline"           => $airline[0],
                    "flightNumber"      => $flightNumber[0],
                    "departureDay"      => $departureDay[0],
                    "departureMonth"    => $departureMonth  ? $departureMonth[0]    : "",
                    "departureYear"     => $departureYear   ? $departureYear[0]     : "",
                ];
            }
            else {
                list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $aircraftName, $departureAirport, $arrivalAirport) = $matches;
                $messageDetails = [
                    "airline"           => $airline[0],
                    "flightNumber"      => $flightNumber[0],
                    "departureDay"      => $departureDay[0],
                    "departureMonth"    => $departureMonth      ? $departureMonth[0]    : "",
                    "aircraftName"      => $aircraftName        ? $aircraftName[0]      : null,
                    "departureAirport"  => $departureAirport    ? $departureAirport[0]  : "",
                    "arrivalAirport"    => $arrivalAirport      ? $arrivalAirport[0]    : null,
                ];
            }

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck, $messageDetails["departureMonth"]);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            // Create Message
            if ($message){
                debug(getFlightNumberFull($flightNumber). " MSG: ".$this->parseOperations->othersMessageType);

                Parse::updateMessage($message, $this->parseOperations->othersMessageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }

        }

        return false;
    }
}
