<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseNOT
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        $pattern = '/.*(?:NOT(?:OC)?\s)[\s\S]*([0-9A-Z]{3})\s*([0-9A-Z]{2}[A-Z]?)\s*([0-9]{1,5}[A-Z]?)\s*[\/]([0-9]{2})/m';

        $this->parseOperations->messageType = $this->parseOperations->messageType == NOTOC ? NOT : $this->parseOperations->messageType;

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $departureAirport, $airline, $flightNumber, $departureDay) = $matches;
            $messageDetails = [
                "departureAirport"  => $departureAirport[0],
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
            ];

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            // Create Message
            if ($message){
                Parse::updateMessage($message, NOT, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, NOT, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }

        }

        return false;
    }
}
