<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;

use App\Classes\Parsing\Helpers\ParseHelper;
use App\Classes\Parsing\Helpers\ParseValidation;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\CALMessage;
use App\Models\Country;
use App\Models\CPMMessage;
use App\Models\CrewListMessage;
use App\Models\HBGMessage;
use App\Models\LDMmessage;
use App\Models\LIRMessage;
use App\Models\MVTMessage;
use App\Models\OtherMessage;
use App\Models\PNLMessage;
use App\Models\PRLMessage;
use App\Models\PSMMessage;
use App\Models\PTMMessage;
use App\Models\SLSMessage;
use App\Models\TPMMessage;
use App\Models\UCMMessage;
use Illuminate\Support\Facades\DB;

class ParseMessagesOperations
{
    public $types = [
        CPM,
        UCM,
        LOADSHEET,
        LOADSHEET_FINAL,
        LDM,
        PSM,
        PTM,
        LPM,
        TPM,
        FAG,
        ONLOAD,
        NOT,
        NOTOC,
        COMRO,
        COM,
        WAB,
        TXT_ING,
        PNL,
        PRL,
        ADL,
        SLS,
        HBG,
        LIR,
        CAL,
        PAL,

        CREW_LIST,
    ];

    public $sentDate;
    public $airportIDs;
    public $countryIDs;
    public $countryISOIDs;

    public $airlines;
    public $airlinesICAO;

    public $airlineIDs;
    public $airlineICAOIDs;
    public $messageLog = [];

    public $emailBody;
    public $singleMessageID = null;
    public $messageType;
    public $othersMessageType;
    public $mvtType;

    public $handlingAirline;

    public $skipDateRangeCheck = null;

    public $airlineModule;
    public $AIRLINE;

    public $localTimeMessages = [
        PRL,
        PNL,
        ADL,
        PTM,
        PSM,
        SLS,
        TPM,
        PSM,
    ];

    public $exceptionStationsList = [
        "LDB",
    ];


    public $handlingAirports = [];

    public $parseHelper;
    public $parseValidation;

    public $hubStations = null;
    public $hubEmails = null;
    public $stationEmails = null;

    public function __construct($sentDate = null, $airportIDs = null, $countryIDs = null, $countryISOIDs = null, $skipDateRangeCheck = null){

        $this->airlineModule = airlineModule();
        $this->AIRLINE = env(AIRLINE);

        if ($this->airlineModule){
            // set email hub and stations
            $hubEmailsAndStations = Parse::setHubStationsAndEmails();
            $this->hubStations = $hubEmailsAndStations[0];
            $this->hubEmails = $hubEmailsAndStations[1];

            // set station emails
            $this->stationEmails = Parse::setStationEmailRecipients();
        }
        else {
            $this->handlingAirports = Airport::listHandlingStations();
        }

        // Helper
        $this->parseHelper = new ParseHelper($this);

        // Validation
        $this->parseValidation = new ParseValidation($this);

        $this->sentDate = $sentDate ? $sentDate : date("Y-m-d");

        $this->airportIDs = $airportIDs ? $airportIDs : Airport::whereNotNull("iata")->pluck("id", "iata")->all();

        $this->countryIDs = $countryIDs ? $countryIDs : Country::whereNotNull("abbr")->pluck("id", "abbr")->all();
        $this->countryISOIDs = $countryISOIDs ? $countryISOIDs : Country::whereNotNull("iso_alpha_3")->pluck("id", "iso_alpha_3")->all();

        $this->airlineIDs = Airline::whereNotNull("iata")->pluck("id", "iata")->all();
        $this->airlineICAOIDs = Airline::whereNotNull("icao")->pluck("id", "icao")->all();

        $this->airlines = Airline::whereNotNull("iata")->get()->keyBy("iata")->all();
        $this->airlinesICAO = Airline::whereNotNull("icao")->get()->keyBy("icao")->all();

        $this->skipDateRangeCheck = $skipDateRangeCheck;
    }

    public function processExceptionStations(&$messageDetails){
        if (!$this->airlineModule){
            return;
        }

        if (isset($messageDetails['departureAirport']) && $messageDetails['departureAirport']){
           if (in_array($messageDetails['departureAirport'], $this->exceptionStationsList)){
               $messageDetails['departureAirport'] = null;
           }
        }

        if (isset($messageDetails['arrivalAirport']) && $messageDetails['arrivalAirport']){
            if (in_array($messageDetails['arrivalAirport'], $this->exceptionStationsList)){
                $messageDetails['arrivalAirport'] = null;
            }
        }
    }

    public function proceedWithAutoCreation($parseEmail, $airline = null){
        if (!$parseEmail && !$this->messageType){
            return true;
        }

        $msgType = $parseEmail && $parseEmail->messageType ? $parseEmail->messageType : $this->messageType;

//        try {
            if ($airline) {
                switch ($this->AIRLINE) {
                    case GSRM:
                        // Iraqi Airlines, PC
                        if (in_array($airline->id, [468, 437])) {
                            return false;
                        }
                        // U6 Ural,
                        if (in_array($airline->id, [854]) && in_array($msgType, [PNL, PSM, PTM])) {
                            return false;
                        }

                        if (in_array($airline->id, [470]) && in_array($msgType, [PSM, PTM])) {
                            return false;
                        }
                        break;

                    case DHS:
                        // XC Airline
                        if (in_array($airline->id, [947]) && in_array($msgType, [TPM])) {
                            return false;
                        }
                        break;
                }
            }
//        }
//        catch (\Exception $e){}

        // List of messages that should not create flights automatically
        return !in_array($msgType, [ADL, NOTOC, NOT, UCM, SLS]);
    }

    /**
     * Applies for handling
     * skips unnecessary messages for airlines' airports which aren't handled by company
     * @param $airline
     * @param $flightNumber
     * @return bool|void
     */
    public function skipAirportMessages( $airline, $flightNumber){
        if ($this->airlineModule || !$airline || !$airline->iata || !$flightNumber){
            return false;
        }

        $handlingAirports = $depAP = $arrAP = null;

        if ($flightNumber->departureAirport){
            $depAP = $flightNumber->departureAirport->iata;
        }
        if ($flightNumber->arrivalAirport){
            $arrAP = $flightNumber->arrivalAirport->iata;
        }

        switch ($airline->iata){
            case "A3":
                $handlingAirports = ["HAM"];
                break;

            case "8Q":
            case "5Q":
                $handlingAirports = ["FRA"];
                break;

            case "KK":
                $handlingAirports = ["HAM", "MUC", "STR"];
                break;

            default:
                return false;
        }

        // Only applies to specific airlines
        if ($handlingAirports && ($depAP || $arrAP)) {
            if ($depAP && $arrAP) {
                if (!in_array($depAP, $handlingAirports) && !in_array($arrAP, $handlingAirports)) {
                    return true;
                }
            } else if ($depAP) {
                if (!in_array($depAP, $handlingAirports)) {
                    return true;
                }
            } else if ($arrAP) {
                if (!in_array($arrAP, $handlingAirports)) {
                    return true;
                }
            }
        }

        return false;
    }

    public function isLocalTimeMessage(){
        return in_array($this->messageType, $this->localTimeMessages);
    }

    protected $limit;
    protected $parseAgain;
    protected $type;
    protected $partialParsing;

    protected $totalMessages;
    protected $parsedMessages;

    public function preRun($type, $limit, $partialParsing = null, $parseAgain = null){
        $this->totalMessages = 0;
        $this->parsedMessages = 0;

        $this->partialParsing = $partialParsing && $partialParsing == PARTIAL_PARSING;

        $this->limit = $limit;
        $this->parseAgain = $parseAgain;
        $this->messageType = $type;


        debug("Message Type {$type}");

        $this->run();

        return [
            "total"         => $this->totalMessages,
            "parsed"        => $this->parsedMessages,
        ];
    }

    public function runSingle($type, $id){
        $this->totalMessages = 0;
        $this->parsedMessages = 0;

        $this->messageType = $type;
        $this->singleMessageID = $id;

        $this->run();

        return [
            "total"         => $this->totalMessages,
            "parsed"        => $this->parsedMessages,
        ];
    }

    function queryWithParseAgain(&$messages){
        if ($this->singleMessageID){
            $messages->where("id", $this->singleMessageID);
        }
        else if ($this->parseAgain) {
            $messages->where(DB::raw("DATE(created_at)"), $this->limit);
        }
        else {
            $messages->whereNull("seen")
                    ->where("created_at", ">", $this->limit)
                    ->whereNull("parsed")
                    ->orderBy("received_datetime");
        }
    }

    function run(){

        switch($this->messageType){
            case MVT:
                $messages = MVTMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    switch($each->type){
                        case MVT_DEPARTURE:
                            try {
                                $result = new ParseMVTDep($this);
                                $response = $result->run($emailBody, null, $each);
                            }
                            catch(\Exception $e){
                                Parse::sendSimpleEmailNotification("Type: MVT Departure\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                            }
                            break;

                        case MVT_ARRIVAL:
                            try {
                                $result = new ParseMVTArr($this);
                                $response = $result->run($emailBody, null, $each);
                            }
                            catch(\Exception $e){
                                Parse::sendSimpleEmailNotification("Type: MVT Arrival\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                            }
                            break;

                        case MVT_DIVERSION:
                            try {
                                $result = new ParseDIV($this);
                                $response = $result->run($emailBody, null, $each);
                            }
                            catch (\Exception $e) {
                                Parse::sendSimpleEmailNotification("Type: DIV\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());  }
                            break;
                    }

//                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** Updated ***
            case LDM:
                $messages = LDMmessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                debug($this->messageType);

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseLDMUpdated($this);
                        $response = $result->run($emailBody, null, $each);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }
                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** Baggage ***
            case CPM:
                $messages = CPMMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseCPM($this);
                        $response = $result->run($emailBody, null, $each, $this->partialParsing);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }
//                    debug("TYPE:".$this->messageType. " - rows:".$i." Response: ". $response);

                    $this->checkAndUpdateResponse($each, $response);
                }

                $this->totalMessages = count($messages);

                break;

            //*** Baggage ***
            case UCM:
                $messages = UCMMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseUCM($this);
                        $response = $result->run($emailBody, null, $each, $this->partialParsing);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i." Response: ". $response);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** Updated ***
            case SLS:
                $messages = SLSMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseSLS($this);
                        $response = $result->run($emailBody, null, $each);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** Updated ***
            case HBG:
                $messages = HBGMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseHBG($this);
                        $response = $result->run($emailBody, null, $each);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** Updated ***
            case LIR:
                $messages = LIRMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseLIR($this);
                        $response = $result->run($emailBody, null, $each);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** Updated ***
            case CAL:
            case PAL:
                $messages = CALMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseCAL($this);
                        $response = $result->run($emailBody, null, $each);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** Updated ***
            case CREW_LIST:
                $messages = CrewListMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseCrewList($this);
                        $response = $result->run($emailBody, null, $each);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //// PAX INFORMATION PARSING

            //*** PAX Data ***
            case PTM:
                $messages = PTMMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParsePTM($this);
                        $response = $result->run($emailBody, null, $each, $this->partialParsing);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** PAX Data ***
            case PSM:
                $messages = PSMMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {

                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParsePSM($this);
                        $response = $result->run($emailBody, null, $each, $this->partialParsing);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** PAX Data ***
            case PNL:
                $messages = PNLMessage::where("type", $this->messageType);

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParsePNL($this);
                        $response = $result->run($emailBody, null, $each, $this->partialParsing);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());  }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** PAX Data ***
            case ADL:
                $messages = PNLMessage::where("type", $this->messageType);

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseADL($this);
                        $response = $result->run($emailBody, null, $each, $this->partialParsing);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString()); }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** PAX Data ***
            case PRL:
                $messages = PRLMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParsePRL($this);
                        $response = $result->run($emailBody, null, $each, $this->partialParsing);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);

                }

                $this->totalMessages = count($messages);

                break;

            //*** PAX Data ***
            case TPM:
                $messages = TPMMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);

                    try {
                        $result = new ParseTPM($this);
                        $response = $result->run($emailBody, null, $each, $this->partialParsing);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$this->messageType."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage()."\n\n Line: \n".$e->getLine()."\n\n Trace: \n".$e->getTraceAsString());
                    }

                    debug("TYPE:".$this->messageType. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);
                }

                $this->totalMessages = count($messages);

                break;

            //// END PAX PARSING
            case OTHS:
            case LOADSHEET:
            case LOADSHEET_FINAL:
            case NOT:
            case NOTOC:
            case FAG:
            case ONLOAD:
            case WAB:
            case COM:
            case COMRO:
            case TXT_ING:
            case LDS:
            default:
                $messages = OtherMessage::select();

                // Add If Parse Again
                $this->queryWithParseAgain($messages);

                $messages = $messages->get();

                foreach ($messages as $i => &$each) {
                    $response = INITIATED;
                    $emailBody = str_replace("=0D", "", $each->email_body);
                    $this->othersMessageType = $each->type;

                    try {
                        $result = $this->getOthersMessageMethod($each->type);
                        $response = $result->run($emailBody, null, $each);
                    }
                    catch(\Exception $e){
                        Parse::sendSimpleEmailNotification("Type: \n".$each->type."\n\n". "Message: \n".$emailBody."\n\n Error: \n".$e->getMessage());
                    }

                    debug("TYPE:".$each->type. " - rows:".$i);

                    $this->checkAndUpdateResponse($each, $response);
                }

                $this->totalMessages = count($messages);

                break;
        }
    }

    function checkAndUpdateResponse(&$message, $response){
        if ($response !== INITIATED){
            $message->seen = true;
            $message->parsed = $response;
            $message->save();

            $this->parsedMessages++;
        }
    }

    function getOthersMessageMethod($type){
        $result = null;

        switch($type){
            case LOADSHEET:
                $result = new ParseLoadsheet($this);
                break;

            //*** Updated ***
            case LOADSHEET_FINAL:
                $result = new ParseLoadsheetFinal($this);
                break;

            //*** Updated ***
            case NOT:
            case NOTOC:
                $result = new ParseNOT($this);
                break;

            case FAG:
                $result = new ParseFAG($this);
                break;

            case ONLOAD:
                $result = new ParseONLOAD($this);
                break;

            case WAB:
            case COM:
            case COMRO:
            case TXT_ING:
            case LDS:
                $result = new ParseOthers($this);
                break;

            default:
                $result = new ParseOthers($this);
                break;
        }

        return $result;
    }

}
