<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseMVTArr
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        if (env(CARRIER) == AIRLINE && env(AIRLINE) == TAJIK_AIR) {

            $messageDetails = self::arrivalTypeFormatIATA($parseText);

            // Try another format
            if (!$messageDetails) {
                $messageDetails = self::arrivalTypeFormat1($parseText);
            }
        }
        else {
            $messageDetails = self::arrivalTypeFormatIATA($parseText);
        }

        if (!$messageDetails) {
            // Create Message
            if ($parseEmail && !$message) {
                $parseEmail->createMessage();
            }
        }

        // Process Exception Station List
        $this->parseOperations->processExceptionStations($messageDetails);

        debug($messageDetails);

        $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck);
        if (!$date){
            return false;
        }

        //**** Updated Find mechanism *****
        $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

        if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
            return null;
        }

        $flight = $findFlight["flight"];
        $aircraft = $findFlight["aircraft"];
        $airline = $findFlight["airline"];
        $flightNumber = $findFlight["flightNumber"];
        $codeShare = $findFlight["codeShare"];

        debug($messageDetails);

        // For TJK AIR do not update the system
        if (!($this->parseOperations->airlineModule && env(AIRLINE) == TAJIK_AIR)) {
            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);


            // 05.05.23
            // If the flight has AD and AC Reg - then if AA comes with different AC Reg - system should not update AC Reg
            if (!skipMVTArrMessage($flight, $aircraft, $messageDetails[ATA])
                && $aircraft && $flight && $flight->flightChild){
                $flight->flightChild->edited_by_email = MVT;
                $flight->flightChild->aircraft_id = $aircraft->id;
                $flight->flightChild->save();
            }
        }

        // Create Message
        if ($message){
            Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
        }
        else {
            if ($parseEmail){
                $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                /// $emailSubject = $parseEmail->emailSubject;

                // Forward emails to:
                // 1.Email HUB
                // 2.Departure/Arrival Stations' emails
                /*
                if ($this->parseOperations->airlineModule){

                    list($subject, $content) = prepareMVTArrivalText($flight); // $this->parseOperations->emailBody

                    Parse::forwardMVTToStations($subject, $content, $flightNumber,
                        $this->parseOperations->hubStations, $this->parseOperations->hubEmails, $this->parseOperations->stationEmails );
                }
                */
                /// -----------------
            }
            else {
                Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails, $this->parseOperations->mvtType);
            }
        }

        return true;
    }

    public static function arrivalTypeFormatIATA($parseText){
        $pattern = '/^\s*MVT\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\s*\/([0-9]{2})[\s\.]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})[\s\.]*([A-Za-z]+)\s*AA([0-9]+)(?:\/([0-9]+))?\s*(?:SI\s*(.*\s*)\s*)*/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($arrivalMessage, $airline, $flightNumber, $departureDay, $aircraftName, $arrivalAirport, $tdn, $ata, $additionalInfo) = $matches;
            $messageDetails = [
                "airline"        => $airline[0],
                "flightNumber"   => $flightNumber[0],
                "departureDay"   => $departureDay[0],
                "aircraftName"   => $aircraftName[0],
                "arrivalAirport" => $arrivalAirport[0],
                "tdn"            => $tdn && isset($tdn[0]) && (strlen($tdn[0]) == 4 || strlen($tdn[0]) == 6) ? $tdn[0] : null,
                "ata"            => $ata && isset($ata[0]) && (strlen($ata[0]) == 4 || strlen($ata[0]) == 6) ? $ata[0] : null,
                "additionalInfo" => $additionalInfo ? $additionalInfo[0] : "",
            ];

            return $messageDetails;
        }

        return false;
    }

    public static function arrivalTypeFormat1($parseText){
        $pattern = '/^\s*MVT\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([A-Z]{3})[\.\s]*([A-Z0-9]{3,4})[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})[\.]*[\r\n\s]*AA([0-9]+)(?:\/([0-9]+))?[\r\n\s]*(?:SI-PIC\/([A-Za-z]+\s*[A-Z]*\.?)[\r\n\s]*)?(?:(?:DISPATCHER|DUTY OFFICER)\/([A-Za-z]+\s*[A-Z]*\.?))?/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            //                        1            2            3               4           5           6          7    8      9        10
            list($arrivalMessage, $airline, $flightNumber, $departureDay, $arrivalAirport, $acType, $aircraftName, $tdn, $ata, $pic, $dispatcher) = $matches;
            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "arrivalAirport"    => $arrivalAirport[0],
                "acType"            => $acType[0],  // new
                "aircraftName"      => $aircraftName[0],
                "tdn"               => $tdn && isset($tdn[0]) && (strlen($tdn[0]) == 4 || strlen($tdn[0]) == 6) ? $tdn[0] : null,
                "ata"               => $ata && isset($ata[0]) && (strlen($ata[0]) == 4 || strlen($ata[0]) == 6) ? $ata[0] : null,
                "pic"               => $pic                     ? $pic[0]                   : null, // new
                "dispatcher"        => $dispatcher              ? $dispatcher[0]            : null, // new
            ];

            return $messageDetails;
        }

        return false;
    }
}
