<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseLoadsheetFinal
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        $pattern = '/(?:\.*AN\s*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})[\s\S]*)?(?:LOADSHEET FINAL)\s*(\d{2})(\d{2})\s*EDNO\s*(\d+)[\.\s]*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*(?:([0-9A-Za-z]{3})(?:[\.\s]))?(?:([0-9A-Za-z]{5})(?:[\.\s]))?([A-Za-z]{3})?[\.\s]*(?:([A-Za-z]{3})(?:[\.\s]))?/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $aircraftName, $hr, $min, $edno, $airline, $flightNumber, $departureDay, $departureMonth, $departureYear) = $matches;
            $messageDetails = [
                "aircraftName"      => $aircraftName ? $aircraftName[0] : null,
                "time"              => $hr && $min ? $hr[0].":".$min[0] : null,
                "edno"              => $edno ? $edno[0] : null,
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
            ];

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            // Create Message
            if ($message){
                Parse::updateMessage($message, LOADSHEET_FINAL, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, LOADSHEET_FINAL, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }

        }

        return false;
    }
}
