<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseLIR
{
    public $parseOperations;

    public $messageType = LIR;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        $pattern = '/.*(?:LOADING\s*INSTRUCTION\/REPORT)[\s\S]*^([A-Za-z]{3})\s*([A-Za-z]{3})\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\s*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})\s*([A-Z0-9]+(?:-\d*)?)\s*([0-9]{2})([0-9A-Za-z]{3})([0-9]{2})/m';

        $this->parseOperations->messageType = $this->messageType;

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $departureAirport, $arrivalAirport, $airline, $flightNumber, $aircraftName, $acType,
                $departureDay, $departureMonth, $departureYear) = $matches;

            $messageDetails = [
                "departureAirport"  => $departureAirport    ? $departureAirport[0]  : null,
                "arrivalAirport"    => $arrivalAirport      ? $arrivalAirport[0]    : null,
                "airline"           => $airline             ? $airline[0]           : null,
                "flightNumber"      => $flightNumber        ? $flightNumber[0]      : null,
                "aircraftName"      => $aircraftName        ? $aircraftName[0]      : null,
                "acType"            => $acType              ? $acType[0]            : null,
                "departureDay"      => $departureDay        ? $departureDay[0]      : "",
                "departureMonth"    => $departureMonth      ? $departureMonth[0]    : "",
                "departureYear"     => $departureYear       ? $departureYear[0]     : "",
            ];

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }

        }

        return false;
    }
}
