<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


use App\Models\FlightStation;

class ParseLDMUpdated extends Parse
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    function getParsingPattern($parseText){
        switch ($this->parseOperations->AIRLINE){
            case TAJIK_AIR:
                $pattern = '/^\s*LDM\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})\.([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4}).(?:(?:(\d+)\/)?(\d+))(?:[\s\S]+?(?:-(\w{3})))?/m';
                break;

            default:
                $pattern = '/^\s*LDM\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})\.([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4}).(?:([A-Z0-9]{1,4})-)?(?:(\d{1,3}[JCYMB])|([JCYMB]\d{1,3})[\/]?)?(?:(\d{1,3}[JCYMB])|([JCYMB]\d{1,3}))(?:[\s\S]+?(?:-(\w{3})))?/m';
                break;
        }

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try){
            switch ($this->parseOperations->AIRLINE){
                case TAJIK_AIR:
                    list($body, $airline, $flightNumber, $departureDay, $aircraftName, $capacityC, $capacityY, $arrivalAirport) = $matches;

                    $messageDetails = [
                        "airline"           => $airline[0],
                        "flightNumber"      => $flightNumber[0],
                        "departureDay"      => $departureDay[0],
                        "aircraftName"      => $aircraftName[0],
                        "capacityC"         => $capacityC   ? $capacityC[0] : null,
                        "capacityY"         => $capacityY   ? $capacityY[0] : null,
                        "arrivalAirport"    => $arrivalAirport   ? $arrivalAirport[0] : null,
                    ];

                    return $messageDetails;

                default:
                    list($body, $airline, $flightNumber, $departureDay, $aircraftName, $acType, $capCY1, $capCY2, $capCY3, $capCY4, $arrivalAirport) = $matches;

                    $messageDetails = [
                        "airline"           => $airline[0],
                        "flightNumber"      => $flightNumber[0],
                        "departureDay"      => $departureDay[0],
                        "aircraftName"      => $aircraftName[0],
                        "acType"            => $acType ? $acType[0] : null,
                        "capCY1"            => $capCY1   ? $capCY1[0] : null,
                        "capCY2"            => $capCY2   ? $capCY2[0] : null,
                        "capCY3"            => $capCY3   ? $capCY3[0] : null,
                        "capCY4"            => $capCY4   ? $capCY4[0] : null,
                        "capacityC"         => null,
                        "capacityY"         => null,
                        "arrivalAirport"    => $arrivalAirport   ? $arrivalAirport[0] : null,
                    ];

                    getConfigFromText($messageDetails, "capCY1");
                    getConfigFromText($messageDetails, "capCY2");
                    getConfigFromText($messageDetails, "capCY3");
                    getConfigFromText($messageDetails, "capCY4");

                    return $messageDetails;

            }
        }

        return null;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        $messageDetails = $this->getParsingPattern($parseText);

        if ($messageDetails)
        {
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck);

            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            // Each Station original

            $pattern = '/(?:-([0-9A-Za-z]{3})[\.\/](\d{1,3})[\/](\d{1,3})(?:[\/](\d{1,3}))?(?:[\/](\d{1,3}))?.*\.T(\d+)(?:\.1\/(\d+))?(?:\.2\/(\d+))?(?:\.3\/(\d+))?(?:\.4\/(\d+))?(?:[\n\r\s]*\.5\/(\d+))?)(?:[\s\S]*?(?:(?:PAX|PX)\/(?:(?:([0-9]+)\/)?([0-9]+)\/)?([0-9]+)))/m';

            $try = preg_match_all($pattern, $parseText, $matchStations);

            if ($try) {
                $paxAdults = $paxM = $paxF = null;

                list($body, $arrivalAirports, $paxM, $paxF, $paxCh, $paxInf, $totalWt, $comp1Wt, $comp2Wt, $comp3Wt, $comp4Wt, $comp5Wt,
                    $paxA, $paxC, $paxY) = $matchStations;

                $paxAdultsTotal = $paxMTotal = $paxFTotal = $paxChTotal = $paxInfTotal = $paxCTotal = $paxYTotal = 0;
                $baggage = $baggagePcs = $cargo = $cargoPcs = $mail = $eic = 0;

                $totalWtTotal = $comp1WtTotal = $comp2WtTotal = $comp3WtTotal = $comp4WtTotal = $comp5WtTotal = 0;

                //$patternBCME = '/(?:[\.\s](\w{3})\s*([B|C|M|E])[\.\/ ]((?:\d+|NIL)(?:[\/]\d+)?))(?:[\.\s]([B|C|M|E])[\.\/ ]((?:\d+|NIL)(?:[\/]\d+)?))?(?:[\.\s]([B|C|M|E])[\.\/ ]((?:\d+|NIL)(?:[\/]\d+)?))?(?:[\.\s]([B|C|M|E])[\.\/ ]((?:\d+|NIL)(?:[\/]\d+)?))?/m';

                if ($findFlight["airline"]->iata == "BA") {
                    $patternBCME = '/(?:[\.\s](\w{3})\s+(\w{3})[\.\/\s]*((?:\d+|NIL)(?:[\/]\d+)?))(?:[\.\s](\w{3})[\.\/\s]((?:\d+|NIL)(?:[\/]\d+)?))?(?:[\.\s]*(\w{3})[\.\/\s]*((?:\d+|NIL)(?:[\/]\d+)?))?(?:[\.\s]*(\w{3})[\.\/\s]*((?:\d+|NIL)(?:[\/\s]*\d+)?))?/m';
                }
                else {
                    $patternBCME = '/(?:[\.\s](\w{3})\s*([B|C|M|E])[\.\/\s]*((?:\d+|NIL)(?:[\/]\d+)?))(?:[\.\s]([B|C|M|E])[\.\/\s]((?:\d+|NIL)(?:[\/]\d+)?))?(?:[\.\s]([B|C|M|E])[\.\/\s]*((?:\d+|NIL)(?:[\/]\d+)?))?(?:[\.\s]*([B|C|M|E])[\.\/\s]*((?:\d+|NIL)(?:[\/\s]*\d+)?))?/m';
//
                }

                $tryBCME = preg_match_all($patternBCME, $parseText, $matchBCME);
                if ($tryBCME){
                    list($body, $airports, $bcme1, $value1, $bcme2, $value2, $bcme3, $value3, $bcme4, $value4) = $matchBCME;
                }

                $tryBAG = preg_match_all("/^.([0-9A-Za-z]{3})\.FRE\/(\d+)\.POS\/(\d+).BAG\/(\d+)\/(\d+).TRA\/(\d+)/m", $parseText, $matchBag);
                if ($tryBAG){
                    list($body, $airports, $freCargo, $posMail, $bagPcs, $bagTotal, $tra) = $matchBag;
                }



                $data = [];
                foreach ($arrivalAirports as $i => $eachAirport) {
                    debug($eachAirport);
                    if ($eachAirport){

                        if (!isset($data[$eachAirport])) {

                            $paxAdults = null;
                            if ($paxInf[$i] == null || $paxInf[$i] == ""){
                                $paxInf[$i] = $paxCh[$i];
                                $paxCh[$i] = $paxF[$i];
                                $paxAdults = $paxM[$i];
                                $paxM[$i] = $paxF[$i] = null;
                            }


                            $data[$eachAirport] = [
                                'flight_id'         => $flight ? $flight->id : null,
                                'flight_number_id'  => $flightNumber ? $flightNumber->id : null,
                                'email_type'        => LDM,
                                "airport_id"        => isset($this->parseOperations->airportIDs[$eachAirport]) ? $this->parseOperations->airportIDs[$eachAirport] : null,
                                "airport"           => $eachAirport ? $eachAirport : null,

                                "paxAdults"         => $paxAdults,
                                "paxM"              => $paxM[$i],
                                "paxF"              => $paxF[$i],

                                "paxCh"             => $paxCh[$i]   ? $paxCh[$i]   : 0,
                                "paxInf"            => $paxInf[$i]  ? $paxInf[$i]  : 0,
                                "paxC"              => $paxC[$i]    ? $paxC[$i]    : 0,
                                "paxY"              => $paxY[$i]    ? $paxY[$i]    : 0,

                                "totalWt"           => $totalWt[$i]     ? $totalWt[$i]    : 0,
                                "comp1Wt"           => $comp1Wt[$i]     ? $comp1Wt[$i]    : 0,
                                "comp2Wt"           => $comp2Wt[$i]     ? $comp2Wt[$i]    : 0,
                                "comp3Wt"           => $comp3Wt[$i]     ? $comp3Wt[$i]    : 0,
                                "comp4Wt"           => $comp4Wt[$i]     ? $comp4Wt[$i]    : 0,
                                "comp5Wt"           => $comp5Wt[$i]     ? $comp5Wt[$i]    : 0,
                            ];

                            if ($parseEmail) {
                                $data[$eachAirport]['email_id'] = $parseEmail->messageId;
                            }

                            $paxAdultsTotal += $data[$eachAirport]["paxAdults"];
                            $paxMTotal      += $data[$eachAirport]["paxM"];
                            $paxFTotal      += $data[$eachAirport]["paxF"];
                            $paxChTotal     += $data[$eachAirport]["paxCh"];
                            $paxInfTotal    += $data[$eachAirport]["paxInf"];
                            $paxCTotal      += $data[$eachAirport]["paxC"];
                            $paxYTotal      += $data[$eachAirport]["paxY"];

                            $totalWtTotal   += $data[$eachAirport]["totalWt"];
                            $comp1WtTotal   += $data[$eachAirport]["comp1Wt"];
                            $comp2WtTotal   += $data[$eachAirport]["comp2Wt"];
                            $comp3WtTotal   += $data[$eachAirport]["comp3Wt"];
                            $comp4WtTotal   += $data[$eachAirport]["comp4Wt"];
                            $comp5WtTotal   += $data[$eachAirport]["comp5Wt"];

                            if ($tryBCME && isset($airports[$i]) && $airports[$i] == $eachAirport) {
                                $bcme = [];
                                if ($bcme1 && $bcme1[$i] && $value1 && isset($value1[$i]) && $value1[$i] != "NIL") {
                                    $bcme[$bcme1[$i]] = $value1[$i];
                                }
                                if ($bcme2 && $bcme2[$i] && $value2 && isset($value2[$i]) && $value2[$i] != "NIL") {
                                    $bcme[$bcme2[$i]] = $value2[$i];
                                }
                                if ($bcme3 && $bcme3[$i] && $value3 && isset($value3[$i]) && $value3[$i] != "NIL") {
                                    $bcme[$bcme3[$i]] = $value3[$i];
                                }
                                if ($bcme4 && $bcme4[$i] && $value4 && isset($value4[$i]) && $value4[$i] != "NIL") {
                                    $bcme[$bcme4[$i]] = $value4[$i];
                                }

                                // Get Baggage Mail Cargo
                                Parse::getBaggageMailCargo($bcme, $data[$eachAirport]);

                                $baggagePcs     += (isset($data[$eachAirport]['baggage_pcs'])  ? $data[$eachAirport]['baggage_pcs']  : 0);
                                $baggage        += (isset($data[$eachAirport]['baggage'])      ? $data[$eachAirport]['baggage']      : 0);

                                $cargoPcs       += (isset($data[$eachAirport]['cargo_pcs'])    ? $data[$eachAirport]['cargo_pcs']    : 0);
                                $cargo          += (isset($data[$eachAirport]['cargo'])        ? $data[$eachAirport]['cargo']        : 0);
                                $eic            += (isset($data[$eachAirport]['eic'])          ? $data[$eachAirport]['eic']          : 0);
                                $mail           += (isset($data[$eachAirport]['mail'])         ? $data[$eachAirport]['mail']         : 0);
                            }
                            else if ($tryBAG && isset($airports) && $airports[$i] == $eachAirport) {
                      //                    list($body, $airports, $freCargo, $posMail, $bagPcs, $bagTotal, $tra) = $matchBag;
                                if (isset($freCargo[$i]) && $freCargo[$i]){
                                    $data[$eachAirport]["cargo"] = $freCargo[$i];
                                    $cargo += $freCargo[$i];
                                }
                                if (isset($posMail[$i]) && $posMail[$i]){
                                    $data[$eachAirport]["mail"] = $posMail[$i];
                                    $mail += $posMail[$i];
                                }
                                if (isset($bagPcs[$i]) && $bagPcs[$i]){
                                    $data[$eachAirport]["baggage_pcs"] = $bagPcs[$i];
                                    $baggagePcs += $bagPcs[$i];
                                }
                                if (isset($bagTotal[$i]) && $bagTotal[$i]){
                                    $data[$eachAirport]["baggage"] = $bagTotal[$i];
                                    $baggage += $bagTotal[$i];
                                }
                            }
                        }
                    }

                    if ($flight) {
                        if (count($data) <= 1) {
                            FlightStation::where("flight_id", $flight->id)->delete();
                        } else {
                            FlightStation::updateFlightStations($flight, $this->parseOperations->sentDate, $data, $parseEmail);
                        }
                    }
                }


                //$messageDetails["arrivalAirport"] = isset($arrivalAirports[0])          ? $arrivalAirports[0]         : null;
                $messageDetails["baggage"]      = $baggage          ? $baggage          : null;
                $messageDetails["baggage_pcs"]  = $baggagePcs       ? $baggagePcs       : null;
                $messageDetails["cargo"]        = $cargo            ? $cargo            : null;
                $messageDetails["cargo_pcs"]    = $cargoPcs         ? $cargoPcs         : null;
                $messageDetails["eic"]          = $eic              ? $eic              : null;
                $messageDetails["mail"]         = $mail             ? $mail             : null;

                $messageDetails["paxAdults"]    = $paxAdultsTotal   ? $paxAdultsTotal   : null;
                $messageDetails["paxM"]         = $paxMTotal        ? $paxMTotal        : null;
                $messageDetails["paxF"]         = $paxFTotal        ? $paxFTotal        : null;
                $messageDetails["paxCh"]        = $paxChTotal       ? $paxChTotal       : null;
                $messageDetails["paxInf"]       = $paxInfTotal      ? $paxInfTotal      : null;
                $messageDetails["paxC"]         = $paxCTotal        ? $paxCTotal        : null;
                $messageDetails["paxY"]         = $paxYTotal        ? $paxYTotal        : null;

                $messageDetails["totalWt"]     = $totalWtTotal      ? $totalWtTotal     : null;
                $messageDetails["comp1Wt"]     = $comp1WtTotal      ? $comp1WtTotal     : null;
                $messageDetails["comp2Wt"]     = $comp2WtTotal      ? $comp2WtTotal     : null;
                $messageDetails["comp3Wt"]     = $comp3WtTotal      ? $comp3WtTotal     : null;
                $messageDetails["comp4Wt"]     = $comp4WtTotal      ? $comp4WtTotal     : null;
                $messageDetails["comp5Wt"]     = $comp5WtTotal      ? $comp5WtTotal     : null;

                // Update Flight Info
                // Disabled for now
            }

            // Baggage
            if (!isset($messageDetails["baggage"])) {
                $bPattern = '/^(?:\.PAX|SI)[\s\S]*(?:[\s\.]+[B][\/\s]?(?:(\d+)\/)?(\d+))/m';
                if (preg_match_all($bPattern, $parseText, $matchesB)) {
                    list($body, $baggagePcs, $baggage) = $matchesB;
                    $messageDetails["baggage_pcs"] = $baggagePcs ? $baggagePcs[0] : null;
                    $messageDetails["baggage"] = $baggage ? $baggage[0] : null;
                }
            }

            // Cargo
            if (!isset($messageDetails["cargo"])) {
//                $cPattern = '/^(?:\.PAX|SI)[\s\S]*(?:[\s\.]+[C][\/\s]?(\d+))/m';
//                if (preg_match_all($cPattern, $parseText, $matchesC)) {
//                    list($body, $cargo) = $matchesC;
//                    $messageDetails["cargo"] = $cargo ? $cargo[0] : null;
//                }
                $cPattern = '/^(?:\.PAX|SI)[\s\S]*(?:[\s\.]+[C][\/\s]?(?:(\d+)\/)?(\d+))/m';
                if (preg_match_all($cPattern, $parseText, $matchesC)) {
                    list($body, $cargoPcs, $cargo) = $matchesC;
                    $messageDetails["cargo_pcs"] = $cargoPcs ? $cargoPcs[0] : null;
                    $messageDetails["cargo"] = $cargo ? $cargo[0] : null;
                }
            }

            // Mail
            if (!isset($messageDetails["mail"])) {
                $mPattern = '/^(?:\.PAX|SI)[\s\S]*(?:[\s\.]+[M][\/\s]?(\d+))/m';
                if (preg_match_all($mPattern, $parseText, $matchesM)) {
                    list($body, $mail) = $matchesM;
                    $messageDetails["mail"] = $mail ? $mail[0] : null;
                }
            }

            debug($messageDetails);

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            if ($flight){
                $flight->ldm = date("Y-m-d H:i:s");
                $flight->edited_by_email = LDM;
                $flight->save();

                // Added on JAN8 2020
                // If flights are matched
                if ($aircraft && $flight->flightChild){
                    $flight->flightChild->edited_by_email = LDM;
                    $flight->flightChild->aircraft_id = $aircraft->id;
                    $flight->flightChild->save();
                }
            }

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }
        }

        return false;
    }
}
