<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseFAG
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        $pattern = '/(?:FAG)[\s\S]*?([0-9A-Z]{3})\s*([0-9A-Z]{3})\s*([0-9A-Z]{2}[A-Z]?)\s([0-9]{1,5}[A-Z]?)\/([0-9]{2})\s*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})\s*(?:(\d{1,3}[JCYB])|([JCYB]\d{1,3})[\/]?)?(?:(\d{1,3}[JCYB])|([JCYB]\d{1,3}))?/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $departureAirport, $arrivalAirport, $airline, $flightNumber, $departureDay, $aircraftName,  $capCY1, $capCY2, $capCY3, $capCY4) = $matches;
            $messageDetails = [
                "departureAirport"  => $departureAirport    ? $departureAirport[0]  : null,
                "arrivalAirport"    => $arrivalAirport      ? $arrivalAirport[0]    : null,
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "aircraftName"      => $aircraftName ? $aircraftName[0] : null,

                // Disabled on OCT/16/2019
//                "capCY1"            => $capCY1   ? $capCY1[0] : null,
//                "capCY2"            => $capCY2   ? $capCY2[0] : null,
//                "capCY3"            => $capCY3   ? $capCY3[0] : null,
//                "capCY4"            => $capCY4   ? $capCY4[0] : null,
//                "capacityC"         => null,
//                "capacityY"         => null,
            ];

//            getConfigFromText($messageDetails, "capCY1");
//            getConfigFromText($messageDetails, "capCY2");
//            getConfigFromText($messageDetails, "capCY3");
//            getConfigFromText($messageDetails, "capCY4");

            debug($messageDetails);

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            // Create Message
            if ($message){
                Parse::updateMessage($message, LDS, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->messageType = LDS;
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, LDS, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->messageType = LDS;
                $parseEmail->createMessage();
            }

        }

        return false;
    }
}
