<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;

use App\Models\CALMessage;
use App\Models\CPMMessage;
use App\Models\CrewListMessage;
use App\Models\HBGMessage;
use App\Models\LDMmessage;
use App\Models\LIRMessage;
use App\Models\LPMMessage;
use App\Models\MVTMessage;
use App\Models\OtherMessage;
use App\Models\PNLMessage;
use App\Models\PRLMessage;
use App\Models\PSMMessage;
use App\Models\PTMMessage;
use App\Models\ResultMessage;
use App\Models\SLSMessage;
use App\Models\TPMMessage;
use App\Models\UCMMessage;


class ParseEmail
{
    protected $stream;

    public $emailSubject;
    public $emailBody;

    protected $emailId;
    protected $sentDate;
    protected $udate;
    protected $senderEmail;

    public $messageType;
    public $mvtType;
    public $messageLog = [];
    public $messageId;

    public function __construct($stream){
        $this->stream = $stream;
    }

    public function getStream(){
        return $this->stream;
    }

    public function getEmailID(){
        return $this->emailId;
    }

    public function setVariables($emailId, $emailSubject, $emailBody, $sentDate, $senderEmail, $messageLog, $messageId, $udate){
        $this->emailId = $emailId;
        $this->emailSubject = $emailSubject;
        $this->emailBody = $emailBody;
        $this->sentDate = $sentDate;
        $this->senderEmail = $senderEmail;
        $this->messageLog = $messageLog;
        $this->messageId = $messageId;
        $this->udate = $udate;
    }

    public function createBlankMessage()
    {
        $this->createMessage(null, null, null, true);
    }

    public function createMessage($flight = null, $flightNumber = null, $messageDetails = null, $blank = null)
    {
        $message = $headers = null;
//        try {
//            if ($this->stream && $this->emailId) {
//                $headers = imap_header($this->stream, $this->emailId);
//            }
//        }
//        catch (\Exception $e){
//            debug($e->getMessage());
//        }

        try {
            // UCM|PSM|PTM|CPM|LPM|TPM|COM|COMRO|WAB
            switch ($this->messageType) {
                case PNL:
                case ADL:
                    $message = new PNLMessage();
                    $message->type = $this->messageType;
                    $message->part = isset($messageDetails['part']) && $messageDetails['part'] ? $messageDetails['part'] : null;
                    $message->pax_y = isset($messageDetails['paxY']) && $messageDetails['paxY'] ? $messageDetails['paxY'] : null;
                    break;

                case PRL:
                    $message = new PRLMessage();
                    $message->part = isset($messageDetails['part']) && $messageDetails['part'] ? $messageDetails['part'] : null;
                    $message->pax_y = isset($messageDetails['paxY']) && $messageDetails['paxY'] ? $messageDetails['paxY'] : null;
                    break;

                case MVT:
                    $message = new MVTMessage();
                    $message->type = $this->mvtType;
                    break;

                case LDM:
                    $message = new LDMmessage();
                    break;

                case UCM:
                    $message = new UCMMessage();
                    break;

                case PSM:
                    $message = new PSMMessage();
                    break;

                case PTM:
                    $message = new PTMMessage();
                    break;

                case CPM:
                    $message = new CPMMessage();
                    break;

                case LPM:
                    $message = new LPMMessage();
                    break;

                case TPM:
                    $message = new TPMMessage();
                    break;

                case SLS:
                    $message = new SLSMessage();
                    break;

                case HBG:
                    $message = new HBGMessage();
                    break;

                case LIR:
                    $message = new LIRMessage();
                    break;

                case CAL:
                case PAL:
                    $message = new CALMessage();
                    break;

                case CREW_LIST:
                    $message = new CrewListMessage();
                    break;

                case NOT:
                case NOTOC:
                    $message = new OtherMessage();
                    $message->type = NOT;
                    break;

                case WAB:
                case COM:
                case COMRO:
                case TXT_ING:
                case ONLOAD:
                case LDS:
                case LOADSHEET:
                case LOADSHEET_FINAL:
                    $message = new OtherMessage();
                    $message->type = $this->messageType;
                    break;


                default:
                    $message = new OtherMessage();
                    $message->type = OTHS;
                    break;
            }

            if ($flight) {
                $message->flight_id = $flight->id;
                $message->parsed = true;
            }
            if (!$messageDetails && !$blank) {
                $this->messageLog[] = "Email body does not match with regExp";
            }

            $message->log = $this->messageLog && count($this->messageLog) ? serialize($this->messageLog) : null;
            $message->flight_number_id = $flightNumber ? $flightNumber->id : null;
            $message->received_datetime = $this->sentDate;
            $message->data = $messageDetails ? serialize($messageDetails) : null;

            $message->email_id = $this->emailId;
            $message->message_id = $this->messageId;
            $message->udate = $this->udate;

            $message->from_email = $this->senderEmail ? $this->senderEmail : (isset($headers) && $headers ? $headers->senderaddress : null); // $headers->from ? serialize($headers->from) : null;
            $message->to_email = isset($headers) && $headers && isset($headers->toaddress) && $headers->toaddress ? $headers->toaddress : null; //$headers->to ? serialize($headers->to) : null;
            $message->email_body = /*strlen($this->emailBody) > 10000 ? str_limit($this->emailBody, 10000) : */$this->emailBody;
            $message->email_title = isset($headers) && $headers && isset($headers->subject) && $headers->subject ? $headers->subject : null;

            $message->created_at = date("Y-m-d H:i:s");
            $message->updated_at = date("Y-m-d H:i:s");
            $message->save();
        }
        catch(\Exception $e){
            Parse::sendEmailNotification($this->messageLog,
                "MSG TYPE: " . $this->messageType. "\n".
                "MSG Obj: \n".
                ($message ? print_r($message, true) : "NULL")."\n".
                "ERROR: ".
            $e->getMessage());
        }

        // Empty out log
        $this->messageLog = [];

        if ($flight && $message) {
            Parse::createFlightMessage($flight, $this->messageType, $message);
        }

        return $message;
    }

    public function updateMessage(&$message, $flight = null, $flightNumber = null, $messageDetails = null)
    {
        try {
            switch ($this->messageType) {
                case PNL:
                case ADL:
                case PRL:
                    $message->part = isset($messageDetails['part']) && $messageDetails['part'] ? $messageDetails['part'] : null;
                    $message->pax_y = isset($messageDetails['paxY']) && $messageDetails['paxY'] ? $messageDetails['paxY'] : null;
                    break;
            }

            $createFlightMessage = !$message->flight_id;

            if ($flight) {
                $message->flight_id = $flight->id;
                $message->parsed = true;
            }

            if (!$messageDetails) {
                $this->messageLog[] = "Email body does not match with regExp";
            }

            $message->seen = true;
            $message->log = $this->messageLog && count($this->messageLog) ? serialize($this->messageLog) : null;
            $message->flight_number_id = $flightNumber ? $flightNumber->id : null;
            $message->data = $messageDetails ? serialize($messageDetails) : null;
            $message->updated_at = date("Y-m-d H:i:s");
            $message->save();

            if ($createFlightMessage && $flight) {
                Parse::createFlightMessage($flight, $this->messageType, $message);
            }
        }
        catch(\Exception $e){
            Parse::sendEmailNotification($this->messageLog, $e->getMessage());
        }

        // Empty out log
        $this->messageLog = [];
    }


    /**
     * Check if email already parsed
     * @return bool
     */
    public function messageExists(){

        // UCM|PSM|PTM|CPM|LPM|TPM|COM|WAB
        switch($this->messageType){
            case PNL :
            case ADL:
                $result = PNLMessage::select();
                break;

            case MVT :
                $result = MVTMessage::select();
                break;

            case LDM :
                $result = LDMmessage::select();
                break;

            case UCM :
                $result = UCMMessage::select();
                break;

            case PSM :
                $result = PSMMessage::select();
                break;

            case PTM :
                $result = PTMMessage::select();
                break;

            case CPM :
                $result = CPMMessage::select();
                break;

            case LPM :
                $result = LPMMessage::select();
                break;

            case TPM :
                $result = TPMMessage::select();
                break;

            case PRL :
                $result = PRLMessage::select();
                break;

            case SLS :
                $result = SLSMessage::select();
                break;

            case HBG:
                $result = HBGMessage::select();
                break;

            case LIR:
                $result = LIRMessage::select();
                break;

            case CAL:
            case PAL:
                $result = CALMessage::select();
                break;

            case CREW_LIST:
                $result = CrewListMessage::select();
                break;

            case WAB:
            case COM:
            case COMRO:
            case TXT_ING:
            case LOADSHEET_FINAL:
                $result = OtherMessage::where("type", $this->messageType);
                break;

            default:
                $result = OtherMessage::select();
                break;
        }

        if ($this->messageId){
            $result->whereNotNull("message_id")
                   ->where("message_id", $this->messageId);
        }
        else {
            $result->where("udate", $this->udate)
                   ->where("from_email", $this->senderEmail);
        }

        $result = $result->first();

        if ($result && $this->messageType == PNL){
            //$this->info("Message {$this->messageType} (UDATE: {$this->udate} | SENDER:{$this->senderEmail}) SKIPPED. Already exists!");
        }

        return $result ? true : false;
    }

    /**
     * Get email subject
     * @return bool|string
     */
    private function getEmailSubject()
    {
        if (!$this->emailId)
        {
            return FALSE;
        }
        $header = imap_header($this->stream, $this->emailId);
        return $header->subject;
    }

    /**
     * Mark email as UNREAD
     */
    public function markEmailAsUnread()
    {
        imap_clearflag_full($this->stream, $this->emailId, "\\Seen");
    }

}
