<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseDIV
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        if (env(CARRIER) == AIRLINE && env(AIRLINE) == TAJIK_AIR) {

            $messageDetails = self::departureTypeFormatIATAupdated($parseText);

            // Try another format
            /*
            if (!$messageDetails){
                $messageDetails = self::departureTypeFormat1($parseText);
            }
            */
        }
        else {
            $messageDetails = self::departureTypeFormatIATAupdated($parseText);
        }

        if (!$messageDetails){
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }

            return false;
        }

        // Process Exception Station List
        $this->parseOperations->processExceptionStations($messageDetails);

        debug($messageDetails);

        // Get Month And Year Of Email Sent Date And Departure Date From Details
        $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck);
        if (!$date){
            return false;
        }

        //**** Updated Find mechanism *****
        $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

        if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
            return null;
        }

        $flight = $findFlight["flight"];
        $aircraft = $findFlight["aircraft"];
        $airline = $findFlight["airline"];
        $flightNumber = $findFlight["flightNumber"];
        $codeShare = $findFlight["codeShare"];

        // For TJK AIR do not update the system
        if (!($this->parseOperations->airlineModule && env(AIRLINE) == TAJIK_AIR)){
            //**** Updated edit mechanism *****
            // $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);
        }

        // Create Message
        if ($message){
            Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
        }
        else {
            if ($parseEmail){
                $parseEmail->createMessage($flight, $flightNumber, $messageDetails);

                // Forward emails to:
                // 1.Email HUB
                // 2.Departure/Arrival Stations' emails
                /*
                if ($this->parseOperations->airlineModule){

                    // $emailSubject = $parseEmail->emailSubject;

                    // Content
                    list($subject, $content) = prepareMVTDepartureADText($flight); // $this->parseOperations->emailBody

                    Parse::forwardMVTToStations($subject, $content, $flightNumber,
                        $this->parseOperations->hubStations, $this->parseOperations->hubEmails, $this->parseOperations->stationEmails );
                }
                */
                /// -----------------
            }
            else {
                Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails, $this->parseOperations->mvtType);
            }
        }

        return true;

    }

    public static function departureTypeFormatIATAupdated($parseText){
        $pattern = '/^\s*DIV\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})[\.\s]*([A-Z]{3})\s*(?:EA\s*([0-9]+))?(?:[\.\s]*([A-Z]{3})?)?\s*(?:SI\s*(.*\s*)\s*)?(?:(?:DR)([0-9A-Z]{1,3}(?:[\s\/][0-9A-Z]{1,3}[\s\/])?)(?:[\s\/]*([0-9]{4}(?:[\s\/][0-9]{4})?))?\s*)?(?:SI\s*(.*\s*)\s*)?(?:(?:(?:PAX|PX|SI\s*PA?X)?[\s\-]*(?:(?:(\d+)[\/])?(\d+)[\/])?(\d+)(?:\s*(?:[\+]|PLUS)\s*(\d*))?).*)?(?:SI\s*(.*)\s*)?/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $airline, $flightNumber, $departureDay, $aircraftName, $arrivalAirport,
                $eta, $divArrivalAirport, $si, $delayCodes, $delayTimes, $si2,
                $paxA, $paxC, $paxY, $paxInf, $si3) = $matches;
            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "aircraftName"      => $aircraftName[0],
                "arrivalAirport"    => $arrivalAirport[0],

                "is_diversion"      => true,
                "eta"               => $eta && isset($eta[0]) && (strlen($eta[0]) == 4 || strlen($eta[0]) == 6) ? $eta[0] : null,
                "divArrivalAirport" => $divArrivalAirport ? $divArrivalAirport[0] : null,
                "si"                => $si          ? $si[0]            : null,
                "delayCodes"        => $delayCodes  && isset($delayCodes[0]) ? rtrim($delayCodes[0], "/") : "",
                "delayTimes"        => $delayTimes  ? $delayTimes[0]    : "",
                "si2"               => $si2         ? $si2[0] : null,

                "paxMvtA"           => $paxA        ? $paxA[0]          : 0,
                "paxMvtC"           => $paxC        ? $paxC[0]          : 0,
                "paxMvtY"           => $paxY        ? $paxY[0]          : 0,
                "paxMvtInf"         => $paxInf      ? $paxInf[0]        : "",
                "si3"               => $si3         ? $si3[0] : "",
            ];

            $messageDetails["paxMvtTotal"] = $messageDetails["paxMvtA"] + $messageDetails["paxMvtC"] + $messageDetails["paxMvtY"];

            debug($messageDetails);

            return $messageDetails;
        }

        return false;
    }

    public static function departureTypeFormatIATA($parseText){
        $pattern = '/^\s*DIV\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})[\.\s]*([A-Z]{3})\s*(?:EA\s*([0-9]+))?(?:[\.\s]*([A-Z]{3})?)?\s*(?:SI\s*(.*\s*)\s*)?(?:(?:DL)([0-9A-Z]{1,3}(?:[\s\/][0-9A-Z]{1,3}[\s\/])?)(?:[\s\/]*([0-9]{4}(?:[\s\/][0-9]{4})?))?\s*)?(?:SI\s*(.*\s*)\s*)?(?:(?:(?:PAX|PX|SI\s*PA?X)?[\s\-]*(?:(?:(\d+)[\/])?(\d+)[\/])?(\d+)(?:\s*(?:[\+]|PLUS)\s*(\d*))?).*)?(?:SI\s*(.*)\s*)?/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $airline, $flightNumber, $departureDay, $aircraftName, $departureAirport, $eta, $arrivalAirport, $si, $delayCodes, $delayTimes, $si2, $paxA, $paxC, $paxY, $paxInf, $delayDescription) = $matches;
            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "aircraftName"      => $aircraftName[0],
                "departureAirport"  => $departureAirport[0],
                "eta"               => $eta && isset($eta[0]) && (strlen($eta[0]) == 4 || strlen($eta[0]) == 6) ? $eta[0] : null,
                "arrivalAirport"    => $arrivalAirport ? $arrivalAirport[0] : null,
                "si"                => $si          ? $si[0]            : null,
                "paxMvtA"           => $paxA        ? $paxA[0]          : 0,
                "paxMvtC"           => $paxC        ? $paxC[0]          : 0,
                "paxMvtY"           => $paxY        ? $paxY[0]          : 0,
                "paxMvtInf"         => $paxInf      ? $paxInf[0]        : "",
                "delayCodes"        => $delayCodes  && isset($delayCodes[0]) ? rtrim($delayCodes[0], "/") : "",
                "delayTimes"        => $delayTimes  ? $delayTimes[0]    : "",

                "si2"               => $si2 ? $si2[0] : null,
                "delayDescription"  => $delayDescription ? $delayDescription[0] : "",
            ];

            $messageDetails["paxMvtTotal"] = $messageDetails["paxMvtA"] + $messageDetails["paxMvtC"] + $messageDetails["paxMvtY"];

            debug($messageDetails);

            return $messageDetails;
        }

        return false;
    }

    public static function departureTypeFormat1($parseText){

        $pattern = '/^\s*DIV\s*([0-9A-Z]{2,3}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*([A-Z]{3})[\.\s]*([A-Z0-9]{3,4})[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})[\.]*[\r\n\s]*(?:(?:AD\s*([0-9]+))|(?:ED\s*([0-9]+)))(?:\/([0-9]+))?[\.\s]*([A-Z]{3})\-([A-Z]{3})[\.\s]*(?:(?:[\.\s]*EA)([0-9]+))?[\r\n\s]*(?:(?:(?:PAX|PX|SI\s*PA?X)?[\s\-\/]*(?:(?:(\d+)[\/])?(\d+)[\/])?(\d+)).*)?[\r\n\s]*(?:INF\/(\d+)[\r\n\s]*)?(?:DL([0-9A-Z]{1,3}(?:[\s\/][0-9A-Z]{1,3}(?:[\s\/][0-9A-Z]{1,3})?)?)?[\s\/]((?:[0-9]{2}[ч]?)?[0-9]{2}(?:мин)?(?:[\s\/](?:[0-9]{2}[ч]?)?[0-9]{2}(?:мин)?(?:[\s\/](?:[0-9]{2}[ч]?)?[0-9]{2}(?:мин)?)?)?)?(?:\/([^\d\r\n]+))?[\r\n\s]*)?(?:SI-BG\/(\d+)[\r\n\s]*)?(?:SI-PIC\/([A-Za-z]+\s*[A-Z]*\.?)[\r\n\s]*)?(?:(?:DISPATCHER|DUTY OFFICER)\/([A-Za-z]+\s*[A-Z]*\.?))?/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            //       0            1               2             3               4                5            6
            list($emailBody, $airlineICAO, $flightNumber, $departureDay, $departureAirport, $acTypeICAO, $aircraftName,
                //    7     8     9        10             11         12     13     14     15     16
                $atd, $etd, $abn, $depAirport, $arrivalAirport, $eta, $paxA, $paxC, $paxY, $paxInf,
                //       17            18          19                 20     21       22
                $delayCodes, $delayTimes, $delayDescriptions, $baggage, $pic, $dispatcher) = $matches;

            $messageDetails = [
                // Base info
                "airline"           => $airlineICAO[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "departureAirport"  => $departureAirport[0],

                "acType"            => $acTypeICAO[0], // new
                "aircraftName"      => $aircraftName[0],
                "atd"               => $atd && isset($atd[0]) && (strlen($atd[0]) == 4 || strlen($atd[0]) == 6) ? $atd[0] : null,
                "etd"               => $etd && isset($etd[0]) && (strlen($etd[0]) == 4 || strlen($etd[0]) == 6) ? $etd[0] : null,
                "abn"               => $abn && isset($abn[0]) && (strlen($abn[0]) == 4 || strlen($abn[0]) == 6) ? $abn[0] : null,
                "arrivalAirport"    => $arrivalAirport ? $arrivalAirport[0] : null,
                "eta"               => $eta && isset($eta[0]) && (strlen($eta[0]) == 4 || strlen($eta[0]) == 6) ? $eta[0] : null,

                // Pax info
                "paxMvtA"           => $paxA        ? $paxA[0]          : 0,
                "paxMvtC"           => $paxC        ? $paxC[0]          : 0,
                "paxMvtY"           => $paxY        ? $paxY[0]          : 0,
                "paxMvtInf"         => $paxInf      ? $paxInf[0]        : "",

                // Up to 3 Delays
                "delayCodes"        => $delayCodes  && isset($delayCodes[0]) ? rtrim($delayCodes[0], "/") : null,
                "delayTimes"        => $delayTimes              ? $delayTimes[0]                : null,
                "delayDescriptions" => $delayDescriptions       ? $delayDescriptions[0]         : null, // new

                // Details
                "baggage"           => $baggage                 ? $baggage[0]          : null, // new
                "pic"               => $pic                     ? $pic[0]                   : null, // new
                "dispatcher"        => $dispatcher              ? $dispatcher[0]            : null, // new
            ];

            $messageDetails["paxMvtTotal"] = $messageDetails["paxMvtA"] + $messageDetails["paxMvtC"] + $messageDetails["paxMvtY"];

            return $messageDetails;
        }

        return false;
    }

}
