<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


use App\Models\Airline;
use App\Models\Container;
use App\Models\ContainerType;
use App\Models\FlightContainer;
use App\Models\FlightContainerInfo;

class ParseCPM
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null, $partialParsing = null){

        $pattern = '/^\s*CPM\s*^\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})([A-Z]{3})?[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})[\.\s]*(?:(\d{1,3}[JCYB])|([JCYB]\d{1,3})[\/]?)?(?:(\d{1,3}[JCYB])|([JCYB]\d{1,3}))?/m';
//        $pattern = '/^\s*CPM\s*^\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})([A-Z]{3})?[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})[\.\s]*(?:C(\d+)\/?)?(?:Y(\d+))?/m';
        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $aircraftName, $capCY1, $capCY2, $capCY3, $capCY4) = $matches;
            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
                "aircraftName"      => $aircraftName    ? $aircraftName[0]  : null,

                // Disabled on OCT/16/2019
//                "capCY1"            => $capCY1   ? $capCY1[0] : null,
//                "capCY2"            => $capCY2   ? $capCY2[0] : null,
//                "capCY3"            => $capCY3   ? $capCY3[0] : null,
//                "capCY4"            => $capCY4   ? $capCY4[0] : null,
//                "capacityC"         => null,
//                "capacityY"         => null,
            ];

//            getConfigFromText($messageDetails, "capCY1");
//            getConfigFromText($messageDetails, "capCY2");
//            getConfigFromText($messageDetails, "capCY3");
//            getConfigFromText($messageDetails, "capCY4");

            debug($messageDetails);

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck, $messageDetails['departureMonth']);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            if (!$partialParsing) {
                // Get Details Info
                $cpmPattern = '/^\-(\d+\w?.*)(?=|[\s\S]*(?:ENDCPM|SI))/m';

                $rowPattern = '/(\d+)([LRP])?(?:\/(\w{3})(\d+)(\w{2}))?(?:\/(\w{3}))?(?:\/(\d+))?(?:[\.\/]((?:\d+)?(?:(?:[A-Z]|[\.\/])+)([0-9]{1})?(?:.*)))/m';

                $readyData = [];

                $flightContainerInfo = null;

                $destinationAirportIATA = null;
                if ($flightNumber && $flightNumber->arrivalAirport && $flightNumber->arrivalAirport->iata) {
                    $destinationAirportIATA = $flightNumber->arrivalAirport->iata;
                }

                if (preg_match_all($cpmPattern, $parseText, $cpmMatches)) {

                    // debug($cpmMatches);

                    if (isset($cpmMatches[1]) && $cpmMatches[1] && count($cpmMatches[1])) {

                        $flightContainerIds = [];

                        // Find record
                        $flightContainerInfo = FlightContainerInfo::whereNull("manual")
                            ->where("flight_id", $flight->id)
                            ->first();

                        // Create New
                        if (!$flightContainerInfo) {
                            $flightContainerInfo = new FlightContainerInfo();
                            $flightContainerInfo->flight_id = $flight->id;
                            $flightContainerInfo->save();
                        }

                        foreach ($cpmMatches[1] as $each) {

                            $split = explode("-", $each);

                            foreach ($split as $row) {

                                if (preg_match_all($rowPattern, $row, $containerMatches)) {
                                    list($rowBody, $rowNumber, $position, $containerTypeName, $containerNo, $owner, $destinationAirport, $weight, $loadedType, $vr) = $containerMatches;

                                    $containerDetails = [
                                        "rowNumber" => $rowNumber[0],
                                        "position" => $position && $position[0] ? $position[0] : null,
                                        "containerTypeName" => $containerTypeName && $containerTypeName[0] ? $containerTypeName[0] : null,
                                        "containerNumber" => $containerNo && $containerNo[0] ? $containerNo[0] : null,
                                        "owner" => $owner && $owner[0] ? $owner[0] : null,
                                        "destinationAirport" => $destinationAirport && $destinationAirport[0] ? $destinationAirport[0] : null,
                                        "weight" => $weight && $weight[0] ? $weight[0] : null,
                                        "loadedType" => $loadedType[0] ? trim($loadedType[0]) : null,
                                        "vr" => $vr ? $vr[0] : null,
                                    ];

                                    // debug($containerDetails);

                                    // DEBUG
                                    ///continue;

                                    // Find Container Type
                                    $containerType = ContainerType::findByName($containerDetails);

                                    // Find Container
                                    $container = Container::find($containerType, $containerDetails, $airline, $this->parseOperations->airlineIDs, $this->parseOperations->airlineICAOIDs);

                                    // Insert To Flights List
                                    $flightContainerIds[] = FlightContainer::insertContainerToFlight(CPM, $flightContainerInfo, $containerType, $container, $containerDetails, $this->parseOperations->airportIDs);

                                    $readyData[] = $containerDetails;
                                }

                            }
                        }

                        // debug($readyData);

                        // DEBUG
                        //return false;

                        // Remove not found flight containers
                        FlightContainer::where("info_id", $flightContainerInfo->id)
                            ->whereNull("from_ucm")
                            ->whereNotIn("id", $flightContainerIds)
                            ->delete();
                    }
                }

                // SI (Additional Info)
                // Needs to be saved somewhere so it could be shown in flight info
                if (preg_match('/SI\s*([\s\S]*)/m', $parseText, $siMatch)) {
                    $messageDetails["si"] = $siMatch[1];
                }
            }

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $message = $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    $message = Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            if (isset($flightContainerInfo) && $flightContainerInfo) {
                if (isset($messageDetails["si"]) && $messageDetails["si"]){
                    $flightContainerInfo->si = $messageDetails["si"];
                }
                if (isset($message) && $message){
                    $flightContainerInfo->message_cpm_id = $message->id;
                }
                $flightContainerInfo->save();
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }
        }

        return false;

    }

}
