<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 16.02.18

 */

namespace App\Classes\Parsing\Helpers;


use App\Classes\Parsing\ParseOperations;

class ParseValidation
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function checkLocalMessagesFlights($flight, $flightNumber, $previousDateApplied = false){
        if (!$this->parseOperations->isLocalTimeMessage()){
            return true;
        }

        if (!$flightNumber->departureAirport){
            return true;
        }

        $timezone = $flightNumber->departureAirport->timezone;
        $depDateTime = getFlightDepartureInitialDate($flight);

        $depDate = date("Y-m-d", strtotime($depDateTime));
        $localDepDate = getLocalDateTime($depDateTime, $timezone, "Y-m-d");

        // Meaning already applied
        if ($previousDateApplied){
            return $depDate != $localDepDate;
        }

        return $depDate == $localDepDate;
    }

}
