<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 16.02.18

 */

namespace App\Classes\Parsing\Helpers;


use App\Classes\Parsing\Parse;
use App\Classes\Parsing\ParseEmail;
use App\Classes\Parsing\ParseMessagesOperations;
use App\Classes\Parsing\ParseOperations;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Flight;
use App\Models\FlightDelay;
use App\Models\FlightNumber;
use Illuminate\Support\Facades\Auth;

class ParseHelper
{
    /**
     * @var ParseMessagesOperations $parseOperations
     */
    public $parseOperations;

    public $skipDateTimeCreation = false;
    public $updateInitialTimings = false;

    public function __construct($parseOperations = null){
        $this->parseOperations = $parseOperations;

        if ($this->parseOperations && !$this->parseOperations->airportIDs){
            $this->parseOperations->airportIDs = Airport::whereNotNull("iata")->pluck("id", "iata")->all();
        }
    }

    public function handlingAirportCheck($messageDetails){
        // SKIP IF ONLY 1 station is mentioned
        if ((!isset($messageDetails["departureAirport"]) || !$messageDetails["departureAirport"])
            || (!isset($messageDetails["arrivalAirport"]) || !$messageDetails["arrivalAirport"]) ){
            return true;
        }

        if (isset($messageDetails["departureAirport"]) && $messageDetails["departureAirport"]){
            if (in_array($messageDetails["departureAirport"], $this->parseOperations->handlingAirports)){
                return true;
            }
        }

        if (isset($messageDetails["arrivalAirport"]) && $messageDetails["arrivalAirport"]){
            if (in_array($messageDetails["arrivalAirport"], $this->parseOperations->handlingAirports)){
                return true;
            }
        }

        return false;
    }

    public function findFlightProcess($messageDetails, $date, $excludeRequiredAircraft = false, ParseEmail $parseEmail = null,
                                      $updateDB = true){

        if (!$this->parseOperations){
            $this->parseOperations = new ParseOperations();
        }

        $messageLog = [];

        // if Airline code not 2(IATA) or 3(ICAO)
        if (!$messageDetails['airline'] || !in_array(strlen($messageDetails['airline']), [2, 3])){

            $messageLog[] = "Airline Code (".$messageDetails['airline'].") is not correct!";

            if ($parseEmail){
                $parseEmail->messageLog[] = "Airline Code (".$messageDetails['airline'].") is not correct!";
            }

            debug("81");

            return [
                "flight"            => null,
                "aircraft"          => null,
                "airline"           => null,
                "flightNumber"      => null,
                "codeShare"         => null,
                "messageLog"        => $messageLog,
            ];
        }

        // Get Airline
        if (strlen($messageDetails["airline"]) == 3){
//            $airline = Airline::where("icao", $messageDetails["airline"])->first();
            $airline = isset($this->parseOperations->airlinesICAO[$messageDetails["airline"]]) ?
                $this->parseOperations->airlinesICAO[$messageDetails["airline"]] : null;
        }
        else {
//            $airline = Airline::where("iata", $messageDetails["airline"])->first();
            $airline = isset($this->parseOperations->airlines[$messageDetails["airline"]]) ?
                $this->parseOperations->airlines[$messageDetails["airline"]] : null;
        }

        if (!$airline){

            $messageLog[] = "Airline Not Found: (".$messageDetails['airline'].")!";

            if ($parseEmail){
                $parseEmail->messageLog[] = "Airline Not Found: (".$messageDetails['airline'].")!";
            }

            return [
                "flight"        => null,
                "aircraft"      => null,
                "airline"       => null,
                "flightNumber"  => null,
                "codeShare"     => null,
                "messageLog"    => $messageLog,
            ];
        }

        if (env(CARRIER) == HANDLING){
            if (!$airline->handling_airline) {
                debug("NON Handling Airline");
                return [
                    "flight"        => null,
                    "aircraft"      => null,
                    "airline"       => null,
                    "flightNumber"  => null,
                    "codeShare"     => null,
                    "messageLog"    => $messageLog,
                ];
            }

            /*
             *
            if (!$this->handlingAirportCheck($messageDetails) &&
                !in_array($this->parseOperations->messageType, [CPM]))
            {
                // MVT Arr has only Arrival AIP
                debug("NON Handling Airport");
                return [
                    "flight"        => null,
                    "aircraft"      => null,
                    "airline"       => null,
                    "flightNumber"  => null,
                    "codeShare"     => null,
                    "messageLog"    => $messageLog,
                ];
            }
             */
        }

        // Find Aircraft
        $aircraft = null;
        if (isset($messageDetails["aircraftName"])){
            // Find the aircraft
            $acType = isset($messageDetails["acType"]) ? $messageDetails["acType"] : null;
            $aircraft = Parse::findAircraft($messageDetails["aircraftName"], $airline, $acType);
//            debug("finding aircraft");
//            debug($aircraft);
        }

        if (!$excludeRequiredAircraft && !$aircraft)
        {
            $messageLog[] = "Aircraft Not Found: (".$messageDetails['aircraftName'].")!";

            if ($parseEmail){
                $parseEmail->messageLog[] = "Aircraft Not Found: (".$messageDetails['aircraftName'].")!";
            }

        }
        // ---------------

        // FIND Flight Numbers
        $findFlightNumbers = [];
        list($foundDepartureAirportId,
            $foundArrivalAirportId,
            $foundDivArrAirportId,
            $arrivalSearch
            ) = $this->findFlightNumber($findFlightNumbers, $messageDetails, $airline);

        // Remove all 0s from beginning
        $messageDetails["flightNumber"] = ltrim($messageDetails["flightNumber"], "0");

        // Add FNs without left 0s
        $this->findFlightNumber($findFlightNumbers, $messageDetails, $airline);
        // END

        $flight = $flightNumber = null;
        $currentDate = date("Y-m-d H:i");

        if (count($findFlightNumbers)) {
            foreach ($findFlightNumbers as $fnEach) {
                $flights = Flight::where("flight_number_id", "=", $fnEach->id)
//                ->where("aircraft_id", "=", $aircraft->id)
                    ->whereNull("cancelled_at")
                    ->whereNull("deleted_at")
//                         (s_flights.atd IS NOT NULL AND s_flights.atd != '' AND DATE(s_flights.atd) = '$date') OR
//                         (s_flights.etd IS NOT NULL AND s_flights.etd != '' AND DATE(s_flights.etd) = '$date') OR
                    ->whereRaw("(
                         (s_flights.ptd IS NOT NULL AND s_flights.ptd != '' AND DATE(s_flights.ptd) = '$date') OR
                         (s_flights.std IS NOT NULL AND s_flights.std != '' AND DATE(s_flights.std) = '$date'))
                         {$arrivalSearch}")
                    ->get();

                // Iterate if more found
                if (count($flights) > 1) {

                    // Iterate flights
                    foreach ($flights as $flEach) {
                        if (!$this->parseOperations->mvtType){
                            // Check for LC Messages
                            if ($result = $this->parseOperations->parseValidation->checkLocalMessagesFlights($flEach, $fnEach)) {
                                $flightNumber = $fnEach;
                                $flight = $flEach;
                                break;
                            }
                        }
                        else {
                            // DEPARTURE
                            if ($this->parseOperations->mvtType == MVT_DEPARTURE){
                                $dep = getFlightDepartureDate($flEach);
//                                debug("DEPARTURE CASE. FLT DEP: ". $dep. " | NOW: ".$currentDate);
                                if (strtotime($dep) <= strtotime($currentDate)){
                                    $flightNumber = $fnEach;
                                    $flight = $flEach;
                                    break;
                                }
                            }
                            // ARRIVAL
                            else {
                                $arr = getFlightArrivalDate($flEach);
//                                debug("ARRIVAL CASE. FLT ARR: ". $arr. " | NOW: ".$currentDate);
                                if (strtotime($arr) <= strtotime($currentDate)){
                                    $flightNumber = $fnEach;
                                    $flight = $flEach;
                                    break;
                                }
                            }
                        }
                    }

                    break;
                }
                // If Flight Found -> Break
                else if (count($flights) == 1){
                    if ($this->parseOperations->parseValidation->checkLocalMessagesFlights($flights->first(), $fnEach)) {
                        $flightNumber = $fnEach;
                        $flight = $flights->first();
//                        debug("MATCHING FLT FOUND: FLT: " . getFlightDepartureDate($flight) . " | NOW: " . $currentDate);
                    }
                    break;
                }
            }

            // NEW CHECK
            // IF Message is ARRIVAL -> which means that no departure timing is mentioned
            // then we might include arrival date
            if (!$flight && $this->parseOperations->mvtType && $this->parseOperations->mvtType == MVT_ARRIVAL){

                foreach ($findFlightNumbers as $fnEach) {
                    $flight = Flight::where("flight_number_id", "=", $fnEach->id)
                        //                ->where("aircraft_id", "=", $aircraft->id)
                        ->whereNull("cancelled_at")
                        ->whereNull("deleted_at")
//                             (s_flights.ata IS NOT NULL AND s_flights.ata != '' AND DATE(s_flights.ata) = '$date') OR
//                             (s_flights.eta IS NOT NULL AND s_flights.eta != '' AND DATE(s_flights.eta) = '$date') OR
                        ->whereRaw("(
                             (s_flights.pta IS NOT NULL AND s_flights.pta != '' AND DATE(s_flights.pta) = '$date') OR
                             (s_flights.sta IS NOT NULL AND s_flights.sta != '' AND DATE(s_flights.sta) = '$date'))
                             {$arrivalSearch}")
                        ->first();
                    // If Flight Found -> Break
                    if ($flight) {
                        $flightNumber = $fnEach;
                        break;
                    }
                }
            }

            // Local Time Messages
            if (!$flight && $this->parseOperations->isLocalTimeMessage()){

                $previousDate = date("Y-m-d", strtotime("-1 days", strtotime($date)));

                foreach ($findFlightNumbers as $fnEach) {

                    $flight = Flight::where("flight_number_id", "=", $fnEach->id)
                        //                ->where("aircraft_id", "=", $aircraft->id)
                        ->whereNull("cancelled_at")
                        ->whereNull("deleted_at")
                        ->whereRaw("(s_flights.std IS NOT NULL AND s_flights.std != '' AND DATE(s_flights.std) = '$previousDate')
                             {$arrivalSearch}")
                        ->first();

                    if ($flight) {
                        if ($this->parseOperations->parseValidation->checkLocalMessagesFlights($flight, $fnEach, true)) {
                            $flightNumber = $fnEach;
                            break;
                        }
                        $flight = null;
                    }
                }

                // Still not found
                if (!$flight){

                    foreach ($findFlightNumbers as $fnEach) {

                        $flight = Flight::where("flight_number_id", "=", $fnEach->id)
                            //                ->where("aircraft_id", "=", $aircraft->id)
                            ->whereNull("cancelled_at")
                            ->whereNull("deleted_at")
//                            (s_flights.atd IS NOT NULL AND s_flights.atd != '' AND DATE(s_flights.atd) = '$date') OR
//                            (s_flights.etd IS NOT NULL AND s_flights.etd != '' AND DATE(s_flights.etd) = '$date') OR
                            ->whereRaw("(
                            (s_flights.ptd IS NOT NULL AND s_flights.ptd != '' AND DATE(s_flights.ptd) = '$date') OR
                            (s_flights.std IS NOT NULL AND s_flights.std != '' AND DATE(s_flights.std) = '$date'))
                                {$arrivalSearch}")
                            ->first();

                        if ($flight) {
                            if ($this->parseOperations->parseValidation->checkLocalMessagesFlights($flight, $fnEach)) {
                                $flightNumber = $fnEach;
                                break;
                            }
                            $flight = null;
                        }
                    }
                }
            }
        }

        // ---------- ADDED 15052018
        if (!$flight){

            $flights = Flight::join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id")
                ->whereNull("flights.cancelled_at")
                ->whereNull("flights.deleted_at")
                ->where("flights__numbers.flight_number", $messageDetails["flightNumber"]);

            if ($aircraft) {
                // $flights->where("aircraft_id", "=", $aircraft->id);
            }

            // MATCH WITH BOTH DEP AND ARR AIRPORTS
            if ($foundDepartureAirportId){
                $flights->where("flights__numbers.departure_airport_id", $foundDepartureAirportId);
            }
            if ($foundArrivalAirportId){
                $flights->where("flights__numbers.arrival_airport_id", $foundArrivalAirportId);
            }

            // ---------------------

//                         (s_flights.atd IS NOT NULL AND s_flights.atd != '' AND DATE(s_flights.atd) = '$date') OR
//                         (s_flights.etd IS NOT NULL AND s_flights.etd != '' AND DATE(s_flights.etd) = '$date') OR
            $flights = $flights->whereRaw("(
                         (s_flights.ptd IS NOT NULL AND s_flights.ptd != '' AND DATE(s_flights.ptd) = '$date') OR
                         (s_flights.std IS NOT NULL AND s_flights.std != '' AND DATE(s_flights.std) = '$date'))")
                ->get(['flights.*']);

            if (count($flights) == 1){
                // Found Match
                $flight = $flights->first();
                $flightNumber = FlightNumber::find($flight->flight_number_id);
            }
            elseif ($aircraft && count($flights) > 1){
                foreach ($flights as $flEach) {
                    if ($flEach->aircraft_id == $aircraft->id){
                        // Found Match
                        $flight = $flEach;
                        $flightNumber = FlightNumber::find($flEach->flight_number_id);
                        break;
                    }
                }
            }
        }
        // END


        // ---------- ADDED 11072018
        // SEARCH by FN and AC WITH ONE OF THE AIRPORTS DEP OR ARR
        // ONLY FOR OTHER MESSAGES EXCEPT MVT
        if ( !$flight&& $aircraft && ($foundDepartureAirportId || $foundArrivalAirportId)
            && $this->parseOperations->mvtType != MVT_DEPARTURE)
        {
            debug("Search by AC - FN - one of the APs");
            $flights = Flight::with(["flightNumber"])
                ->join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id")
                ->whereNull("flights.cancelled_at")
                ->whereNull("flights.deleted_at")
                ->where("flights__numbers.flight_number", $messageDetails["flightNumber"])
                ->where("aircraft_id", "=", $aircraft->id);

            // MATCH WITH ONE OF THE AIRPORTS DEP OR ARR
            if ($foundDepartureAirportId && $foundArrivalAirportId){
                $flights->where(function($sql) use ($foundDepartureAirportId, $foundArrivalAirportId) {
                    $sql->where("flights__numbers.departure_airport_id", $foundDepartureAirportId)
                        ->orWhere("flights__numbers.arrival_airport_id", $foundArrivalAirportId);
                });
            }
            else {
                if ($foundDepartureAirportId) {
                    $flights->where("flights__numbers.departure_airport_id", $foundDepartureAirportId);
                } elseif ($foundArrivalAirportId) {
                    $flights->where("flights__numbers.arrival_airport_id", $foundArrivalAirportId);
                }
            }

//                         (s_flights.atd IS NOT NULL AND s_flights.atd != '' AND DATE(s_flights.atd) = '$date') OR
//                         (s_flights.etd IS NOT NULL AND s_flights.etd != '' AND DATE(s_flights.etd) = '$date') OR
            $flights = $flights->whereRaw("(
                         (s_flights.ptd IS NOT NULL AND s_flights.ptd != '' AND DATE(s_flights.ptd) = '$date') OR
                         (s_flights.std IS NOT NULL AND s_flights.std != '' AND DATE(s_flights.std) = '$date'))")
                ->get(['flights.*']);

            if (count($flights) == 1){
                // Found Match
//                debug("Line 379. MATCH BY AC and FN");
                $flight = $flights->first();
                $flightNumber = FlightNumber::find($flight->flight_number_id);
            }
            elseif (count($flights) > 1){
                foreach ($flights as $flEach) {

                    // Found Match By DEP AP
                    if ($foundDepartureAirportId && $flEach->flightNumber->departure_airport_id == $foundDepartureAirportId)
                    {
//                        debug("Line 389. MATCH BY AC, FN and DEP AP");
                        $flight = $flEach;
                        $flightNumber = FlightNumber::find($flEach->flight_number_id);
                        break;
                    }

                    // Found Match By ARR AP
                    if ($foundArrivalAirportId && $flEach->flightNumber->arrival_airport_id == $foundArrivalAirportId)
                    {
//                        debug("Line 398. MATCH BY AC, FN and ARR AP");
                        $flight = $flEach;
                        $flightNumber = FlightNumber::find($flEach->flight_number_id);
                        break;
                    }
                }
            }

            // IF FLIGHT FOUND -> update FN DEP/ARR APs
            if ($flight && $flightNumber){
                if ($foundDepartureAirportId && !$flightNumber->departure_airport_id){
                    $flightNumber->departure_airport_id = $foundDepartureAirportId;
                }
                if ($foundArrivalAirportId && !$flightNumber->arrival_airport_id){
                    $flightNumber->arrival_airport_id = $foundArrivalAirportId;
                }
                $flightNumber->save();
            }
        }
        // END

        // If not found matching flight create new Flight Number
        if (!$flightNumber) {
            $findFlightNumbers = FlightNumber::where("airline_id", $airline->id)
                ->where("flight_number", $messageDetails["flightNumber"])
                ->where("departure_airport_id", $foundDepartureAirportId)
                ->where("arrival_airport_id", $foundArrivalAirportId)
                ->whereNull("deleted_at")
                ->get();

            if ($findFlightNumbers->count() > 0) {
                $flightNumber = $findFlightNumbers->first();
            } // If Doesn't exists or Many found -> create new
            else {
                $flightNumber = new FlightNumber();
                $flightNumber->airline_id = $airline->id;
                $flightNumber->flight_number = ltrim($messageDetails["flightNumber"], "0");
                $flightNumber->departure_airport_id = $foundDepartureAirportId;
                $flightNumber->arrival_airport_id = $foundArrivalAirportId;
                $flightNumber->save();
            }
        }

        /*
        if (!$flight){
            $findFlightNumbers = FlightNumber::where("airline_id", $airline->id)
                                                ->where("flight_number", $messageDetails["flightNumber"])
                                                ->get();

            foreach ($findFlightNumbers as $fnEach) {
                $flight = Flight::where("flight_number_id", "=", $fnEach->id)
//                ->where("aircraft_id", "=", $aircraft->id)
                    ->whereNull("cancelled_at")
                    ->whereNull("deleted_at")
                    ->whereRaw("((s_flights.atd IS NOT NULL AND s_flights.atd != '' AND DATE(s_flights.atd) = '$date') OR
                         (s_flights.etd IS NOT NULL AND s_flights.etd != '' AND DATE(s_flights.etd) = '$date') OR
                         (s_flights.ptd IS NOT NULL AND s_flights.ptd != '' AND DATE(s_flights.ptd) = '$date') OR
                         (s_flights.std IS NOT NULL AND s_flights.std != '' AND DATE(s_flights.std) = '$date'))
                         {$arrivalSearch}")
                    ->first();

                // If Flight Found -> Break
                if ($flight){
                    $flightNumber = $fnEach;
                    break;
                }
            }

            if (!$flightNumber){
                $flightNumber = $findFlightNumbers->first();
            }
        }
        */

        if ($flight){

            if ($updateDB) {

                $flight->edited_by_email = $parseEmail && $parseEmail->messageType ? $parseEmail->messageType : 1;
                $flight->save();

                // Update Aircraft
                Parse::updateAircraft($aircraft, $flight);
            }
        }
        else{

            // Meaning that flight number might not match, even though the sector arrival or departure
            // airports will match
            $disable = true;
            if ($aircraft && !$disable){
                // Find Flight with This Aircraft Reg
                $flight = Flight::where("aircraft_id", "=", $aircraft->id)
                    ->join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id")
                    ->whereNull("flights.cancelled_at")
                    ->whereNull("flights.deleted_at");

                // GET SAME SECTOR FLIGHT
                if ($flightNumber) {
                    if ($flightNumber->departure_airport_id) {
                        $flight->where("flights__numbers.departure_airport_id", $flightNumber->departure_airport_id);
                    }

                    if ($flightNumber->arrival_airport_id) {
                        $flight->where("flights__numbers.arrival_airport_id", $flightNumber->arrival_airport_id);
                    }
                }
                // ---------------------

//                             (s_flights.atd IS NOT NULL AND s_flights.atd != '' AND DATE(s_flights.atd) = '$date') OR
//                             (s_flights.etd IS NOT NULL AND s_flights.etd != '' AND DATE(s_flights.etd) = '$date') OR
                $flight = $flight->whereRaw("(
                             (s_flights.ptd IS NOT NULL AND s_flights.ptd != '' AND DATE(s_flights.ptd) = '$date') OR
                             (s_flights.std IS NOT NULL AND s_flights.std != '' AND DATE(s_flights.std) = '$date'))")
                    ->first(['flights.*']);

                // If Flight Found Ignore This Email
                if ($flight){

                    if ($updateDB) {
                        // Update Aircraft
                        Parse::updateAircraft($aircraft, $flight);
                    }

                    debug("FLIGHT Found:");
                    debug($flight ? $flight->ptd. "-".getFlightNumber($flight) : "----566----");
                    return [
                        "flight"        => $flight,
                        "aircraft"      => $aircraft,
                        "airline"       => $airline,
                        "flightNumber"  => $flightNumber,
                        "codeShare"     => true,
                        "messageLog"    => $messageLog,
                    ];
                }
            }

            $messageLog[] = "Flight Not Found. Flight Was Created by Email.";

            if ($parseEmail){
                $parseEmail->messageLog[] = "Flight Not Found. Flight Was Created by Email.";
            }

            if ($updateDB) {

                debug("findFlightProcess - 582 - BEFORE PROCEEDING AUTO CREATION");
                // Check if AP
                if (!$this->parseOperations->skipAirportMessages($airline, $flightNumber)
                    && $this->parseOperations->proceedWithAutoCreation($parseEmail, $airline)) {

                    $flight = new Flight();

                    // Create flight and FIX timing IF ATA/TDN > CURRENT TIME
                    if (Parse::findAndUpdateFlightsTimings($flight, $messageDetails, $date)) {
//                    debug("FLIGHT DATE = " . $date);
                        $flight->created_by_email = $parseEmail && $parseEmail->messageType ? $parseEmail->messageType : 1;
                        $flight->created_by = Auth::user() ? Auth::user()->id : null;
                        $flight->flight_number_id = $flightNumber ? $flightNumber->id : null;
                        $flight->aircraft_id = $aircraft ? $aircraft->id : null;
                        $flight->email_type = $parseEmail ? $parseEmail->messageType : null;
                        $flight->email_id = $parseEmail ? $parseEmail->messageId : null;

                        $flight->save();

                        // Email Notification for Auto-created flights
                        try {
                            Parse::sendAutoCreatedEmailNotification($flight);
                        } catch (\Exception $e) {
                            Parse::sendSimpleEmailNotification("Delay Email Notification Error" . "\n\n Error: \n" . $e->getMessage());
                        }
                    }
                    else {
                        $flight = null;
                    }
                }
            }
            else {
                $flight = null;
            }
        }

        // Flight not created
        if (!$flight){
            debug("Flight not created - 624");

            return [
                "flight"        => null,
                "aircraft"      => $aircraft,
                "airline"       => $airline,
                "flightNumber"  => $flightNumber,
                "codeShare"     => false,
                "messageLog"    => $messageLog,
            ];
        }

        if ($updateDB) {
            // Process Arrival Diversion
            Parse::processDiversion(array_key_exists("divArrivalAirport", $messageDetails), $flight, $foundDivArrAirportId, $parseEmail);
        }

        debug("Flight  - 641");
        return [
            "flight"        => $flight,
            "aircraft"      => $aircraft,
            "airline"       => $airline,
            "flightNumber"  => $flightNumber,
            "codeShare"     => false,
            "messageLog"    => $messageLog,
        ];
    }

    function findFlightNumber(&$findFlightNumbers, $messageDetails, $airline){
        $flightNumbers = FlightNumber::where("airline_id", $airline->id)
//            ->where("flight_number", $messageDetails["flightNumber"])
            ->where("flight_number", "REGEXP", "0*".$messageDetails["flightNumber"]."$")
            ->whereNull("deleted_at");

        $foundDepartureAirportId = $foundArrivalAirportId = $foundDivArrAirportId = null;
        if (isset($messageDetails["departureAirport"]) && $messageDetails["departureAirport"]){
            if (!isset($this->parseOperations->airportIDs[$messageDetails["departureAirport"]])) {
                $depAirport = Parse::createAirport($messageDetails["departureAirport"]);
                if ($depAirport){
                    $flightNumbers->where("departure_airport_id", $foundDepartureAirportId = $depAirport->id);
                }
            }
            else {
                $flightNumbers->where("departure_airport_id", $foundDepartureAirportId = $this->parseOperations->airportIDs[$messageDetails["departureAirport"]]);
            }
        }

        $arrivalSearch = "";
        if (isset($messageDetails["arrivalAirport"]) && $messageDetails["arrivalAirport"]) {
            if (!isset($this->parseOperations->airportIDs[$messageDetails["arrivalAirport"]])) {
                $arrAirport = Parse::createAirport($messageDetails["arrivalAirport"]);
                $foundArrivalAirportId = $arrAirport->id;
            }
            else {
                $foundArrivalAirportId = $this->parseOperations->airportIDs[$messageDetails["arrivalAirport"]];
            }

            if ($foundArrivalAirportId){
                $flightNumbers->where("arrival_airport_id", $foundArrivalAirportId);
            }
        }

        if (isset($messageDetails["divArrivalAirport"]) && $messageDetails["divArrivalAirport"]) {
            if (!isset($this->parseOperations->airportIDs[$messageDetails["divArrivalAirport"]])) {
                $divArrAirport = Parse::createAirport($messageDetails["divArrivalAirport"]);
                $foundDivArrAirportId = $divArrAirport->id;
            } else {
                $foundDivArrAirportId = $this->parseOperations->airportIDs[$messageDetails["divArrivalAirport"]];
            }

            if ($foundDivArrAirportId){
                $arrivalSearch = " AND is_diversion=1 AND arrival_airport_id={$foundDivArrAirportId} AND diverted_airport_id={$foundDivArrAirportId}";
            }
        }

        $flightNumbers = $flightNumbers->get();

        if ($flightNumbers->count()){
            foreach ($flightNumbers as $each){
                $findFlightNumbers[] = $each;
            }
        }

        return [
            $foundDepartureAirportId,
            $foundArrivalAirportId,
            $foundDivArrAirportId,
            $arrivalSearch,
        ];
    }

    public function updateFlightInformation(&$flight, $messageDetails, &$aircraft, $date, $codeShare = false, ParseEmail &$parseEmail = null)
    {
        if (!$flight){

            if ($parseEmail){
                $parseEmail->messageLog[] = "Flight Not Found";
            }

            return false;
        }

        if ($codeShare){

            if ($parseEmail){
                $parseEmail->messageLog[] = "Code-share Flight";
            }

            return false;
        }

        // Skip flight update
        if ($this->parseOperations && $this->parseOperations->mvtType){
            // 05.05.23
            // so if the flight has AD and AC Reg - then if AA comes with different AC Reg - system should not update AC Reg
            if ($this->parseOperations->mvtType == MVT_DEPARTURE && skipMVTDepMessage($flight, $aircraft, $messageDetails[ATD])){
                return false;
            }
            else if ($this->parseOperations->mvtType == MVT_ARRIVAL && skipMVTArrMessage($flight, $aircraft, $messageDetails[ATA])){
                return false;
            }
        }

        $now = date("Y-m-d H:i");
        $skipMessage = false;

        if ($this->updateInitialTimings){
            if (isset($messageDetails[STD]) && $messageDetails[STD]) {
                if ($this->skipDateTimeCreation) {
                    $std = $messageDetails[STD];
                } else {
                    $std = Parse::makeDateTime($messageDetails[STD], $date);
                }

                $flight->std = $std;
            }
            if (isset($messageDetails[PTD]) && $messageDetails[PTD]) {
                if ($this->skipDateTimeCreation) {
                    $ptd = $messageDetails[PTD];
                } else {
                    $ptd = Parse::makeDateTime($messageDetails[PTD], $date);
                }

                $flight->ptd = $ptd;
            }

            if (isset($messageDetails[STA]) && $messageDetails[STA]) {
                if ($this->skipDateTimeCreation) {
                    $sta = $messageDetails[STA];
                } else {
                    $sta = Parse::makeDateTime($messageDetails[STA], $date);
                }

                $flight->sta = $sta;
            }
            if (isset($messageDetails[PTA]) && $messageDetails[PTA]) {
                if ($this->skipDateTimeCreation) {
                    $pta = $messageDetails[PTA];
                } else {
                    $pta = Parse::makeDateTime($messageDetails[PTA], $date);
                }

                $flight->pta = $pta;
            }
        }

        $stdPtd = $flight->std && $flight->std != EMPTY_DATETIME ? $flight->std :
            ($flight->ptd && $flight->ptd != EMPTY_DATETIME ? $flight->ptd : null);

        // FIRST PROCESS ATD
        if (isset($messageDetails[ATD]) && $messageDetails[ATD])
        {
            if ($this->skipDateTimeCreation){
                $atd = $messageDetails[ATD];
            }
            else {
                $atd = Parse::makeDateTime($messageDetails[ATD], $date);
            }

            debug("compiled ATD: ". $atd. " NOW: ".$now);
            // 3 mins (180s) margin
            if (strtotime($atd) <= strtotime($now) + 180){
                $flight->atd = $atd;

                // Added on Aug 6 2019
                if ($stdPtd && (strtotime($stdPtd) - strtotime($atd) >= 21600)){ // 6 hours 6*60*60
                    $flight->atd = date("Y-m-d H:i", strtotime(" + 1 days", strtotime($atd)));
                    debug("ATD < STD/PTD. SHIFTED TO NEXT DATE. STD/PTD:{$stdPtd}. ATD: {$atd}, NOW: {$now}");
                }

            }
            else {
                $skipMessage = true;
                debug("MESSAGE SKIPPED");
            }
        }

        // Do not update when ATD > NOW // Skip everything
        if ($skipMessage){
            return false;
        }

        if (isset($messageDetails[ETD]) && $messageDetails[ETD])
        {
            if ($this->skipDateTimeCreation){
                $etd = $messageDetails[ETD];
            }
            else {
                $etd = Parse::makeDateTime($messageDetails[ETD], $date);
            }

            $flight->etd = $etd;

            // Added on Aug 6 2019
            if ($stdPtd && (strtotime($stdPtd) - strtotime($etd) >= 21600)){ // 6 hours 6*60*60
                $flight->etd = date("Y-m-d H:i", strtotime(" + 1 days", strtotime($etd)));
                debug("ETD < STD/PTD. SHIFTED TO NEXT DATE. STD/PTD:{$stdPtd}. ETD: {$etd}, NOW: {$now}");
            }
        }
        if (isset($messageDetails[ABN]) && $messageDetails[ABN])
        {
            if ($this->skipDateTimeCreation){
                $abn = $messageDetails[ABN];
            }
            else {
                $abn = Parse::makeDateTime($messageDetails[ABN], $date);
            }

            if (strtotime($abn) <= strtotime($now)){
                $flight->abn = $abn;

                // Added on Aug 6 2019
                if ($stdPtd && (strtotime($stdPtd) - strtotime($abn) >= 21600)){ // 6 hours 6*60*60
                    $flight->abn = date("Y-m-d H:i", strtotime(" + 1 days", strtotime($abn)));

                    debug("ABN < STD/PTD. SHIFTED TO NEXT DATE. STD/PTD:{$stdPtd}. ABN: {$abn}, NOW: {$now}");
                }
            }
            else {
                debug("ABN SKIPPED. ABN: {$abn}, NOW: {$now}");
            }
        }

        // Get Departure
        $dep = getFlightDepartureDate($flight);

        // FIRST PROCESS ATA
        if (isset($messageDetails[ATA]) && $messageDetails[ATA])
        {
            if ($this->skipDateTimeCreation){
                $ata = $messageDetails[ATA];
            }
            else {
                $ata = Parse::makeDateTime($messageDetails[ATA], $date);
            }

            if (strtotime($ata) < strtotime($dep)){
                $ata = date("Y-m-d H:i", strtotime(" + 1 days", strtotime($ata)));
            }

            // 3 mins (180s) margin
            if (strtotime($ata) <= (strtotime($now) + 180)){
                $flight->ata = $ata;
            }
            else {
                $skipMessage = true;
                debug("MESSAGE SKIPPED");
            }
            debug("ARR after = ".$ata);
            debug("NOW + 3 mins = ".date("Y-m-d H:i", (strtotime($now) + 180)));
        }

        if ($skipMessage){
            return false;
        }

        if (isset($messageDetails[ETA]) && $messageDetails[ETA])
        {
            if ($this->skipDateTimeCreation){
                $eta = $messageDetails[ETA];
            }
            else {
                $eta = Parse::makeDateTime($messageDetails[ETA], $date);
            }

            if (strtotime($eta) > strtotime($dep)){
                $flight->eta = $eta;
            }
            else {
                debug("DEP {$dep} > ETA {$eta}. Thus + 1 days to ETA");
                $flight->eta =  date("Y-m-d H:i", strtotime(" + 1 days", strtotime($eta)));
            }
        }

        if (isset($messageDetails[TDN]) && $messageDetails[TDN])
        {
            if ($this->skipDateTimeCreation){
                $tdn = $messageDetails[TDN];
            }
            else {
                $tdn = Parse::makeDateTime($messageDetails[TDN], $date);
            }

            if (strtotime($tdn) < strtotime($dep)){
                $tdn = date("Y-m-d H:i", strtotime(" + 1 days", strtotime($tdn)));
            }

            if (strtotime($tdn) <= strtotime($now)){
                $flight->tdn = $tdn;
            }
            else {
                debug("TDN SKIPPED. TDN: {$tdn}, NOW: {$now}");
            }
        }

        $initDate = getFlightDepartureInitialDate($flight);
        $actDate = getFlightDepartureDate($flight);

        // in minutes
        $diff = Calculate_Duration($initDate, $actDate, true) * 60;

        if ((isset($messageDetails["delayCodes"]) && $messageDetails["delayCodes"]))
        {
            $delayCodes = explode("/", $messageDetails["delayCodes"]);
            $timeStr = explode("/", $messageDetails["delayTimes"]);

            $delayTimes = [];

            foreach ($delayCodes as $j => $each ) {
                if (isset($timeStr[$j]) && $timeStr[$j]){
                    $dTime = Parse::makeTime(trim($timeStr[$j]));

                    debug("REAL: ".$timeStr[$j]." CONVERTED:".$dTime);
                }
                else {

                    // If 1 delay mentioned assign all delay time to this delay
                    if (count($delayCodes) == 1){
                        $dTime = Minutes_To_Time($diff);
                    }
                    else {

                        if ($j == 0){
                            $dTime = Minutes_To_Time($diff - (count($delayCodes) - 1));
                        }
                        else {
                            $dTime = Parse::makeTime("0001");
                        }
                    }
                }

                $delayTimes[] = $dTime;
            }

            if (isset($messageDetails["extDelayCode"]) && $messageDetails["extDelayCode"] &&
                isset($messageDetails["extDelayTime"]) && $messageDetails["extDelayTime"]){

                $delayCodes[] = trim($messageDetails["extDelayCode"]);
                $delayTimes[] = Parse::makeTime(trim($messageDetails["extDelayTime"]));;

            }

            Flight::SetFlightDelays($flight, $delayCodes, $delayTimes);
        }
        else if (isset($messageDetails["delayDescriptions"]) && $messageDetails["delayDescriptions"]){
            if ($timeStr = $messageDetails["delayTimes"]){

                if (strlen($timeStr) != 4) {

                    if (contains($timeStr, "ч") || contains($timeStr, "мин"))
                    {
                        if (!contains($timeStr, "ч")) {
                            $timeStr = "00" . $timeStr;
                        }
                        if (!contains($timeStr, "мин")) {
                            $timeStr .= "00";
                        }
                    }

                    $timeStr = str_replace(["ч", "мин"], "", $timeStr);
                }

                $dTime = Parse::makeTime(trim($timeStr));
            }
            else {
                $dTime = Minutes_To_Time($diff);
            }

            Flight::SetFlightDelaysNoCode($flight, $dTime, $messageDetails["delayDescriptions"]);
        }
        // No Delays (only for MVT DEP)
        else {
            if ($this->parseOperations && $this->parseOperations->mvtType && $this->parseOperations->mvtType == MVT_DEPARTURE){
                // Remove All Delays
                $fDelay = FlightDelay::where("flight_id", $flight->id)
                    ->get();

                // Audit Deleted
                auditDeleted($fDelay);
            }
        }

        if (array_key_exists("baggage", $messageDetails))
        {
            $flight->baggage =  getIntValueOrNull($messageDetails["baggage"]);
        }
        if (array_key_exists("baggage_pcs", $messageDetails))
        {
            $flight->baggage_pcs =  getIntValueOrNull($messageDetails["baggage_pcs"]);
        }
        if (array_key_exists("cargo", $messageDetails))
        {
            $flight->cargo =  getIntValueOrNull($messageDetails["cargo"]);
        }
        if (array_key_exists("cargo_pcs", $messageDetails))
        {
            $flight->cargo_pcs =  getIntValueOrNull($messageDetails["cargo_pcs"]);
        }
        if (array_key_exists("mail", $messageDetails))
        {
            $flight->mail =  getIntValueOrNull($messageDetails["mail"]);
        }
        if (array_key_exists("eic", $messageDetails))
        {
            $flight->eic =  getIntValueOrNull($messageDetails["eic"]);
        }
        if ((array_key_exists("capacityC", $messageDetails) || array_key_exists("capacityY", $messageDetails))
            && (isset($messageDetails["capacityC"]) || isset($messageDetails["capacityY"]))) {
            if (array_key_exists("capacityC", $messageDetails)) {
                $flight->capacity_c =  getIntValueOrNull($messageDetails["capacityC"]);
            }
            if (array_key_exists("capacityY", $messageDetails)) {
                $flight->capacity_y =  getIntValueOrNull($messageDetails["capacityY"]);
            }
        }
        if (isset($messageDetails["paxC_bkd"]))
        {
            $flight->pax_c_booked =  getIntValueOrNull($messageDetails["paxC_bkd"]);
        }
        if (isset($messageDetails["paxY_bkd"]))
        {
            $flight->pax_y_booked =  getIntValueOrNull($messageDetails["paxY_bkd"]);
        }
        if (isset($messageDetails["paxC"]))
        {
            $flight->pax_c_actual =  getIntValueOrNull($messageDetails["paxC"]);
        }
        if (isset($messageDetails["paxY"]))
        {
            $flight->pax_y_actual =  getIntValueOrNull($messageDetails["paxY"]);
        }
        if (array_key_exists("paxInf", $messageDetails))
        {
            $flight->pax_inf_actual =  getIntValueOrNull($messageDetails["paxInf"]);
        }
        if (array_key_exists("paxAdults", $messageDetails))
        {
            $flight->pax_adults_actual =  getIntValueOrNull($messageDetails["paxAdults"]);
        }
        if (array_key_exists("paxM", $messageDetails))
        {
            $flight->pax_m_actual =  getIntValueOrNull($messageDetails["paxM"]);
        }
        if (array_key_exists("paxF", $messageDetails))
        {
            $flight->pax_f_actual =  getIntValueOrNull($messageDetails["paxF"]);
        }
        if (array_key_exists("paxCh", $messageDetails))
        {
            $flight->pax_ch_actual =  getIntValueOrNull($messageDetails["paxCh"]);
        }
        if (isset($messageDetails["paxMvtTotal"]))
        {
            $flight->pax_mvt_total =  getIntValueOrNull($messageDetails["paxMvtTotal"]);
        }
        if (isset($messageDetails["paxMvtInf"]))
        {
            $flight->pax_mvt_inf =  getIntValueOrNull($messageDetails["paxMvtInf"]);
        }

        if (isset($messageDetails["totalWt"]))
        {
            $flight->cmp_total_wt =  getIntValueOrNull($messageDetails["totalWt"]);
        }
        if (isset($messageDetails["comp1Wt"]))
        {
            $flight->cmp_1_wt =  getIntValueOrNull($messageDetails["comp1Wt"]);
        }
        if (isset($messageDetails["comp2Wt"]))
        {
            $flight->cmp_2_wt =  getIntValueOrNull($messageDetails["comp2Wt"]);
        }
        if (isset($messageDetails["comp3Wt"]))
        {
            $flight->cmp_3_wt =  getIntValueOrNull($messageDetails["comp3Wt"]);
        }
        if (isset($messageDetails["comp4Wt"]))
        {
            $flight->cmp_4_wt =  getIntValueOrNull($messageDetails["comp4Wt"]);
        }
        if (isset($messageDetails["comp5Wt"]))
        {
            $flight->cmp_5_wt =  getIntValueOrNull($messageDetails["comp5Wt"]);
        }
        // New Fields
        if (isset($messageDetails["comp5Wt"]))
        {
            $flight->cmp_5_wt =  getIntValueOrNull($messageDetails["comp5Wt"]);
        }
        if (array_key_exists("fob", $messageDetails))
        {
            $flight->fob = $messageDetails["fob"];

            if ($flight->fob){
                if ($flight->rf){
                    $flight->utilised = ($flight->fob - $flight->rf) >= 0 ? ($flight->fob - $flight->rf) : null;
                }
                else {
                    $utilised = $flight->utilised ? $flight->utilised : 0;
                    $flight->rf = ($flight->fob - $utilised) >= 0 ? ($flight->fob - $utilised) : null;
                }
            }
        }
        if (array_key_exists("in_tanks", $messageDetails))
        {
            $flight->in_tanks =  getIntValueOrNull($messageDetails["in_tanks"]);
        }
        if (array_key_exists("tof", $messageDetails))
        {
            $flight->tof =  getIntValueOrNull($messageDetails["tof"]);
        }
        if (array_key_exists("eet", $messageDetails))
        {
            $flight->eet = makeTime($messageDetails["eet"]);
        }
        if (array_key_exists("rf", $messageDetails))
        {
            $flight->rf =  getIntValueOrNull($messageDetails["rf"]);

            $departureFuel = $flight->fob ? $flight->fob : ($flight->in_tanks + ($flight->uplifted ? $flight->uplifted : 0));

            // correct utilised figures
            if ($departureFuel){
                $flight->utilised = $departureFuel - ($flight->rf ? $flight->rf : 0);
            }
        }
        if (array_key_exists("pic", $messageDetails))
        {
            $flight->pic = $messageDetails["pic"];
        }
        if (array_key_exists("pic_arr", $messageDetails))
        {
            $flight->pic_arr = $messageDetails["pic_arr"];
        }

        if ($aircraft)
        {
            $flight->aircraft_id = $aircraft->id;

            if (!$aircraft->config_c && !$aircraft->config_y){
                if (isset($messageDetails["capacityC"]) && $messageDetails["capacityC"]){
                    $aircraft->config_c =  getIntValueOrNull($messageDetails["capacityC"]);
                }
                if (isset($messageDetails["capacityY"]) && $messageDetails["capacityY"]){
                    $aircraft->config_y =  getIntValueOrNull($messageDetails["capacityY"]);
                }
                $aircraft->save();
            }

        }

        debug($flight);

        // Correct Flight Timings
        try{
            Parse::checkAndCorrectFlightTimings($flight);
        }
        catch(\Exception $e){
            debug($e->getMessage());
        }

        $flight->save();

        return true;
    }

}
