<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;

use App\Classes\Parsing\Helpers\ParseHelper;
use App\Classes\Parsing\Helpers\ParseValidation;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Country;

class FetchMessagesOperations
{
    public $types = [
        CPM,
        UCM,
        LIR,
        LOADSHEET,
        LOADSHEET_FINAL,
        LDM,
        PSM,
        PTM,
        LPM,
        TPM,
        FAG,
        ONLOAD,
        NOT,
        NOTOC,
        COMRO,
        COM,
        WAB,
        PNL,
        PRL,
        ADL,
        SLS,
        HBG,
        CAL,
        PAL,

        TXT_ING,
        CREW_LIST,
    ];

    public $sentDate;
    public $messageLog = [];

    public $emailBody;
    public $messageType;
    public $mvtType;

    public $handlingAirline;

    public $skipDateRangeCheck = null;

    public $airlineModule;
    public $localTimeMessages = [
        PRL,
        PNL,
        ADL,
        PTM,
        PSM,
        SLS,
        TPM,
        PSM,
    ];

    public $exceptionStationsList = [
        "LDB",
    ];

    public function __construct($sentDate = null){

        $this->airlineModule = airlineModule();
    }

    public function run($emailBody, ParseEmail $parseEmail = null){

        $this->emailBody = str_replace("=0D", "", $emailBody);

        $foundMatch = $result = false;

        if (preg_match('/^(?:\s*.\s*)?(DIV)/m', $this->emailBody)) {
            $this->messageType = MVT;

            if ($parseEmail){
                $parseEmail->messageType = $this->messageType;
            }

            if ($parseEmail && $parseEmail->messageExists()) {
                return [
                    "parsed"        => null,
                    "exists"        => true,
                ];
            }
            else {

                $this->mvtType = MVT_DIVERSION;

                $parseEmail->createBlankMessage();
            }
        }
        else if (preg_match('/^(?:\s*.\s*)?(MVT)/m', $this->emailBody)) {

            $this->messageType = MVT;

            if ($parseEmail){
                $parseEmail->messageType = $this->messageType;
            }

            if ($parseEmail && $parseEmail->messageExists()) {
                return [
                    "parsed"        => null,
                    "exists"        => true,
                ];
            }
            else{
                if ($this->airlineModule && $parseEmail) {
                    $headers = imap_header($parseEmail->getStream(), $parseEmail->getEmailID());
                    if (trim($headers->senderaddress) == "grsadm@sirena-travel.ru") {
                        return [
                            "parsed"        => null,
                            "exists"        => false,
                        ];
                    }
                }

                if (preg_match('/\b(?:AD|ED)[0-9]+/m', $this->emailBody)) {

                    debug("MVT - DEPT matched OK");

                    $foundMatch = true;

                    $this->mvtType = MVT_DEPARTURE;

                    if ($parseEmail){
                        $parseEmail->mvtType = $this->mvtType;
                    }

                    //*** Updated ***
                    $parseEmail->createBlankMessage();

                    debug("MVT - ARR CREATED");
                }
                // Arrival message
                else if (preg_match('/\bAA[0-9]+/m', $this->emailBody)) {

                    $foundMatch = true;

                    debug("MVT - ARR matched OK");
                    $this->mvtType = MVT_ARRIVAL;

                    if ($parseEmail){
                        $parseEmail->mvtType = $this->mvtType;
                    }

                    //*** Updated ***
                    $parseEmail->createBlankMessage();
                    debug("MVT - ARR CREATED");
                }

                debug("END");

            }
        }

        // LDM|UCM|PSM|PTM|CPM|LPM|TPM|COMRO|COM|WAB|TXT_ING|PNL|ADL
        else {
            foreach ($this->types as $type)
            {
                // Special case for TXT_ING
                if (preg_match('/^(?:\s*.\s*)?('.
                    ($type == TXT_ING ? 'TXT\/ING' : ($type == LIR ? "LOADING[\s]INSTRUCTION\/REPORT" : $type))
                    .')/m', $this->emailBody)){

                    $foundMatch = true;

                    $this->messageType = $type;

                    if ($parseEmail){
                        $parseEmail->messageType = $this->messageType;
                    }

                    if ($parseEmail && $parseEmail->messageExists()) {
                        return [
                            "parsed"        => true,
                            "exists"        => true,
                        ];
                    }

                    switch($type){

                        //*** Updated ***
                        case LOADSHEET:
                            //$parseEmail->messageType = LOADSHEET_FINAL;
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case LOADSHEET_FINAL:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case CPM:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case UCM:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case PTM:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case PSM:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case LDM:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case PNL:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case ADL:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case NOT:
                        case NOTOC:
                            $parseEmail->createBlankMessage();
                        break;

                        //*** Updated ***
                        case PRL:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case SLS:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case HBG:
                            $parseEmail->createBlankMessage();
                            break;

                        case LIR:
                            $parseEmail->createBlankMessage();
                            break;

                        case CAL:
                        case PAL:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case CREW_LIST:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        case TPM:
                            $parseEmail->createBlankMessage();
                            break;

                        case FAG:
                            $parseEmail->createBlankMessage();
                            break;

                        case ONLOAD:
                            $parseEmail->createBlankMessage();
                            break;

                        //*** Updated ***
                        default:
                            $parseEmail->createBlankMessage();
                            break;
                    }

                    // Break if result, else continue
                    if ($result === null){
                         break;
                    }

                }
            }
        }

        return [
            "parsed"        => null,
            "foundMatch"    => $foundMatch
        ];

        /*
        if ($parseEmail) {

            if (!$foundMatch) {

                if (!$parseEmail->messageExists()) {

                    if (env(SAVE_EMAIL_LOG)){
                        $parseEmail->createBlankMessage();
                    }
                }
            }
        }
        */

    }

}
