<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 04.07.17

 */

namespace App\Classes\Messages;


use App\Models\CALMessage;
use App\Models\CPMMessage;
use App\Models\CrewListMessage;
use App\Models\Flight;
use App\Models\HBGMessage;
use App\Models\LIRMessage;
use App\Models\LPMMessage;
use App\Models\Message2018;
use App\Models\OtherMessage;
use App\Models\Passenger;
use App\Models\PNLMessage;
use App\Models\PRLMessage;
use App\Models\PTMMessage;
use App\Models\SLSMessage;
use App\Models\LDMmessage;
use App\Models\TPMMessage;
use App\Models\UCMMessage;
use App\Models\PSMMessage;

class Message
{

    protected static $messages = [
        PRL,
        PNL,
        MVT,
        LDM,
        LIR,
        CPM,
        CAL,
        LPM,
        PSM,
        PTM,
        UCM,
        TPM,
        LDS,
        NOTOC,
        ONLOAD,
        OTHS,
    ];

    public static function getMessageBody($type, $flightId){
        debug($type);

        switch($type){
            case ADL:
            case PNL:
                $messages   = PNLMessage::select();
                break;

            case PRL:
                $messages   = PRLMessage::select();
                break;

            case LDM:
                $messages   = LDMmessage::select();
                break;

            case UCM:
                $messages   = UCMMessage::select();
                break;

            case PSM:
                $messages   = PSMMessage::select();
                break;

            case PTM:
                $messages   = PTMMessage::select();
                break;

            case CPM:
                $messages   = CPMMessage::select();
                break;

            case LPM:
                $messages   = LPMMessage::select();
                break;

            case TPM:
                $messages   = TPMMessage::select();
                break;

            case SLS:
                $messages   = SLSMessage::select();
                break;

            case HBG:
                $messages   = HBGMessage::select();
                break;

            case LIR:
                $messages   = LIRMessage::select();
                break;

            case CAL:
            case PAL:
                $messages   = CALMessage::select();
                break;

            case CREW_LIST:
                $messages = CrewListMessage::select();
                break;

            case NOT:
                $messages   = OtherMessage::whereIn("type", [NOT, NOTOC]);
                break;

            case LDS:
                $messages   = OtherMessage::whereIn("type", [LDS, LOADSHEET, LOADSHEET_FINAL]);
                break;

            case ONLOAD:
            case OTHS:
                $messages   = OtherMessage::whereNotIn("type", [NOT, NOTOC, LDS, LOADSHEET, LOADSHEET_FINAL]);
                break;

            default:
                return null;
        }

        $messages->where("flight_id", $flightId);

        if (in_array($type, [PRL, PNL]))
        {
            $messages->where("parsed", 1)
                     ->orderBy('part');
        }

        $messages = $messages->orderBy("created_at", "DESC")
            ->get();

        $readyMessages = [];

        foreach ($messages as $j => $each) {
            $readyMessages[] = Flight::parseMessages($each, $type);
        }

        return $readyMessages;
    }

    public static function getMessages($flight){

        $receivedMessages = $plResult = [];

        if (isArchiveMessages($flight)){
            foreach (self::$messages as $type) {
                $allMessages = null;
                $readyMessages = [];

                switch ($type) {

                    case PNL:
                        $readyMessages = Passenger::getPLList($flight->id, $flight->flight_number_id, getFlightDepartureDate($flight, true), $type);
                        $allMessages = Message2018::where("flight_id", $flight->id)
                            ->whereIn("type", [PNL, ADL])
                            ->orderBy("created_at", "DESC")
                            ->get();

                        $readyMessages["pl_data"] = [];
                        foreach ($allMessages as $j => $each) {
                            $readyMessages["pl_data"][] = Flight::parseMessages($each, $type);
                        }
                        break;

                    case PRL:
                        $readyMessages = Passenger::getPLList($flight->id, $flight->flight_number_id, getFlightDepartureDate($flight, true), $type);
                        $allMessages = Message2018::where("flight_id", $flight->id)
                            ->where("message", $type)
                            ->orderBy("created_at", "DESC")
                            ->get();

                        $readyMessages["pl_data"] = [];
                        foreach ($allMessages as $j => $each) {
                            $readyMessages["pl_data"][] = Flight::parseMessages($each, $type);
                        }
                        break;

                    case NOT:
                    case NOTOC:
                        $allMessages = Message2018::where("flight_id", $flight->id)
                            ->whereIn("message", [NOT, NOTOC])
                            ->orderBy("created_at", "DESC")
                            ->get();
                        break;

                    case LDS:
                        $allMessages = Message2018::where("flight_id", $flight->id)
                            ->whereIn("message", [LDS, LOADSHEET, LOADSHEET_FINAL])
                            ->orderBy("created_at", "DESC")
                            ->get();
                        break;

                    case ONLOAD:
                    case OTHS:
                        $allMessages = Message2018::where("flight_id", $flight->id)
                            ->whereNotIn("message", self::$messages)
                            ->orderBy("created_at", "DESC")
                            ->get();
                        break;

                    default:
                        $allMessages = Message2018::where("flight_id", $flight->id)
                            ->where("message", $type)
                            ->orderBy("created_at", "DESC")
                            ->get();
                        break;
                }

                if ($allMessages && $allMessages->count() && !in_array($type, [PRL, PNL])){
                    foreach ($allMessages as $j => $each) {
                        switch ($type) {
                            case MVT:
                                if ($each->type == strtolower(ARRIVAL)) {
                                    $readyMessages["arrival"][] = Flight::parseMVTMessages($each);
                                } else {
                                    $readyMessages["departure"][] = Flight::parseMVTMessages($each);
                                }
                                break;

                            default:
                                $msg = Flight::parseMessages($each, $type);
                                if ($msg){
                                    $readyMessages[] = $msg;
                                }
                                break;
                        }
                    }

                }

                if (count($readyMessages)){
                    $receivedMessages[$type] = $readyMessages;
                }
            }
        }
        else {
            foreach (self::$messages as $type) {
                switch ($type) {
                    case PNL:
                        $plResult = Passenger::getPLList($flight->id, $flight->flight_number_id, getFlightDepartureDate($flight, true), $type);
                        break;

                    case PRL:
                        $plResult = Passenger::getPLList($flight->id, $flight->flight_number_id, getFlightDepartureDate($flight, true), $type);
                        break;

                    case NOT:
                    case NOTOC:
                        $allMessages = OtherMessage::where("flight_id", $flight->id)
                            ->whereIn("type", [NOT, NOTOC])
                            ->orderBy("created_at", "DESC")
                            ->get();
                        break;

                    case LDS:
                        $allMessages = OtherMessage::where("flight_id", $flight->id)
                            ->whereIn("type", [LDS, LOADSHEET, LOADSHEET_FINAL])
                            ->orderBy("created_at", "DESC")
                            ->get();
                        break;

                    case ONLOAD:
                    case OTHS:
                        $allMessages = OtherMessage::where("flight_id", $flight->id)
                            ->whereNotIn("type", [NOT, NOTOC, LDS, LOADSHEET, LOADSHEET_FINAL])
                            ->orderBy("created_at", "DESC")
                            ->get();
                        break;

                    case LDM:
                        $allMessages = $flight->ldmMessage;
                        break;

                    default:
                        $allMessages = $flight->{$type};
                        break;

                }

                $readyMessages = [];
                switch ($type) {
                    case PNL:
                        $readyMessages = $plResult;
                        $allMessages = PNLMessage::where("flight_id", $flight->id)
                            ->orderBy("created_at", "DESC")
                            ->get();

                        $readyMessages["pl_data"] = [];
                        foreach ($allMessages as $j => $each) {
                            $readyMessages["pl_data"][] = Flight::parseMessages($each, $type);
                        }
                        break;

                    case PRL:
                        $readyMessages = $plResult;
                        $allMessages = PRLMessage::where("flight_id", $flight->id)
                            ->orderBy("created_at", "DESC")
                            ->get();

                        $readyMessages["pl_data"] = [];
                        foreach ($allMessages as $j => $each) {
                            $readyMessages["pl_data"][] = Flight::parseMessages($each, $type);
                        }

                        break;

                    default:
                        if (isset($allMessages)) {
                            foreach ($allMessages as $j => $each) {
                                switch ($type) {
                                    case MVT:
                                        if ($each->type == strtolower(ARRIVAL)) {
                                            $readyMessages["arrival"][] = Flight::parseMVTMessages($each);
                                        } else {
                                            $readyMessages["departure"][] = Flight::parseMVTMessages($each);
                                        }
                                        break;

                                    default:
                                        $readyMessages[] = Flight::parseMessages($each, $type);
                                        break;
                                }
                            }
                        }
                        break;
                }


                $receivedMessages[$type] = $readyMessages;
            }
        }

        return $receivedMessages;
    }

}
