<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 19.06.17

 */

namespace App\Classes\MatchFlights;

use App\Models\Airport;

class FlightPosition
{
    protected $stations = [];

    protected $flights = [];

    protected $maintenance = [];

    /** @var  ILine */
    protected $currentLine;

    /** @var ILine[] $lines */
    public $lines = [];

    protected $lineType;

    public $date;

    public $limitFlightsPerLine = null;

    protected $processedFlights = [];

    public function __construct($flights, $maintenance = []){

        // For Airline Module Sort By A/C and A/C type
        if (env(CARRIER) == AIRLINE){

            $this->flights = $flights->sortBy("aircraft_id")
                                     ->sortBy('aircraft_type_id')
                                     ->values()
                                     ->all();

        }
        else {
            $this->stations = Airport::getHandlingStations();

//            $this->flights = $flights;
            $this->flights = $flights->sortBy("airline_id")
                                    ->sortBy('std')
                                    ->sortBy('ptd')
                                    ->sortBy('atd')
                                    ->sortBy('sta')
                                    ->sortBy('pta')
                                    ->sortBy('ata')
                                    ->values();
        }

        $this->maintenance = $maintenance;

        $this->setLineType();
    }

    function setLineType(){
        if (env("CARRIER") == HANDLING){
            $this->lineType = HANDLING;
        }
        else{
           $this->lineType = AIRLINE;
        }
    }

    function createNewLine($flight = null){
        if ($this->lineType == HANDLING){
            return new FlightLineH($this->stations);
        }
        else {
            return new FlightLineA($flight);
        }

    }

    public function run(){
        if ($this->lineType == HANDLING){
            $this->runHandling();
        }
        else {
//            $this->runHandling();
            $this->runAirline();
        }
    }

    function runHandling(){

        $num = 0;

        debug("TOTAL: ".count($this->flights). " flights");

        $handlingStations = Airport::getHandlingStationsIdAndObject();

        foreach ($this->flights as $i => &$each) {
            $each->type = getFlightsDepArrType($each, $handlingStations);
            $each->dep_datetime = getFlightDepartureInitialDate($each);
            $each->dep_date = date("Y-m-d", strtotime($each->dep_datetime));

            $each->arr_datetime = getFlightArrivalInitialDate($each);
            $each->arr_date = date("Y-m-d", strtotime($each->arr_datetime));
        }

        foreach ($this->flights as $i => $each) {

            $this->currentLine = $this->createNewLine();

            foreach ($this->flights as $j => $flight) {

                if (in_array($flight->id, $this->processedFlights))
                {
                    continue;
                }

//                if ($flight->type == DEPARTURE && strtotime(getFlightDepartureInitialDate($flight)) < strtotime($this->date)){
//                    debug("FLIGHT . ". getFlightNumberFull($flight->flightNumber)
//                        ." / ". getFlightDepartureDate($flight));
//                    continue;
//                }

                if ($this->limitFlightsPerLine && $this->currentLine->hasFlights() >= $this->limitFlightsPerLine){
                    break;
                }

                if ($this->currentLine->checkAndAddFlight($flight)){
//                    debug("{$i} ({$j}) - LINE: {$this->currentLine->getNum()} | Flight: STD:".getFlightDepartureDate($flight, false, true).
//                        " STA: ".getFlightArrivalDate($flight, false, true).
//                     "| First Flight Departure {$this->currentLine->getFirstFlightDeparture()}". "| Last Flight Arrival {$this->currentLine->getLastFlightArrival()}");

                    $this->processedFlights[] = $flight->id;
                    debug("FLT: {$flight->id} - processed");
                }
            }

            if ($this->currentLine->hasFlights()){
                $combine = false;

                foreach ($this->lines as $j => $line) {
                    if ($line->combineApplicable($this->currentLine, true)){
//                        debugFlights($line->getFlights(), $j, "BEFORE COMB");
//                        debug("First Flight Departure {$this->currentLine->getFirstFlightDeparture()}". "| Last Flight Arrival {$line->getLastFlightArrival()}");
                        $line->combineLine($this->currentLine);
                        $combine = true;
                        debugFlights($line->getFlights(), $j, "AFTER COMB");
                        break;
                    }
                }

                if (!$combine){
                    $this->currentLine->num = ++$num;
                    $this->lines[] = $this->currentLine;
                }
                debug("{$i} - LINE: {$this->currentLine->getNum()} | Flights: ". count($this->currentLine->getFlights()));
            }
        }

        foreach ($this->lines as $i => $line) {

            if ($line->getStatus() == DELETED){
                continue;
            }

            foreach ($this->lines as $j => $otherLine) {

                if ($line->getNum() == $otherLine->getNum()){
                    continue;
                }

                if ($otherLine->getStatus() == DELETED){
                    continue;
                }

                if ($line->combineApplicable($otherLine)){

                    debugFlights($line->getFlights(), $j, "BEFORE COMB");
                    debug("First Flight Departure {$this->currentLine->getFirstFlightDeparture()}". "| Last Flight Arrival {$line->getLastFlightArrival()}");
                    $this->lines[$i]->combineLine($otherLine);

                    $this->lines[$j]->setStatus(DELETED);
                }
            }
        }

//        debug($this->processedFlights);


        $lines = [];
        foreach ($this->lines as $i => $line) {
            if ($line->getStatus() == DELETED){
                unset($this->lines[$i]);
            }
            else {
                $lines[] = $line;
            }
        }


        $this->lines = [];

        $processedFlights = [];
        foreach ($lines as $i => $each) {
            $flights = $each->getFlights() ;
            debug("FLTS: in Line $j ". count($flights));
            foreach ($flights as $j => $flight) {
                if ($flight->type == DEPARTURE
                    && strtotime(getFlightDepartureDate($flight)) >= strtotime($this->date)
                    && !in_array($flight->id, $processedFlights)) {

                    $line = $this->createNewLine();
                    if ($j > 0 && $flights[$j - 1]->type == ARRIVAL
                        && !in_array($flights[$j - 1]->id, $processedFlights)) {

                        if ($line->checkAndAddFlight($flights[$j - 1])) {
                            // Processed
                            $this->processedFlights[] = $flights[$j - 1]->id;
                        }
                        else {
                            debug($flight->type . "  / LINE FLTS POS: {$j}: " . count($flights));
                            debug("!!! FLIGHT NOT ADDED !!! {$flights[$j - 1]->id}. "
                                . getFlightNumberFull($flights[$j - 1]->flightNumber)
                                . " / " . getFlightDepartureDate($flights[$j - 1]));
                        }
                    }
                    $line->forceAddFlight($flight);
                    // Processed
                    $this->processedFlights[] = $flight->id;

                    $this->lines[] = $line;

                    debug("NEW Line created");
                }
                else if ($j > 0 && $flight->type == ARRIVAL) {
                    debug("FLIGHT ARR not matched - NOT ADDED. ". getFlightNumberFull($flight->flightNumber)
                        ." / ". getFlightArrivalDate($flight));
                }
            }
        }

        debug("LINES: ". count($this->lines));
        foreach ($this->lines as $i => $each){
            debug("LINE: $i Flights Count = ".count($each->getFlights()));
            if (count($each->getFlights()) == 1){
                foreach ($each->getFlights() as $flight){
                    debug(strtotime(getFlightDepartureDate($flight)) >= strtotime($this->date));
                    debug("FLIGHT . ". getFlightNumberFull($flight->flightNumber)." / ". getFlightDepartureDate($flight));
                }
            }
        }

        // Order by Station
        return;
        if ($this->lineType == HANDLING){
            usort($this->lines, array($this, "compareByStation"));

            // Update Num
            foreach ($this->lines as $i => &$each ) {
                $each->setNum($i);
            }
        }

    }

    function runAirline(){

        $num = 0;

//        debug("TOTAL: ".count($this->flights). " flights");

        $countFlights = count($this->flights);

        foreach ($this->flights as $i => $each) {

            if (in_array($each->id, $this->processedFlights))
            {
                continue;
            }

            $this->currentLine = $this->createNewLine($each);

            for ($j = $i + 1; $j < $countFlights; $j++) {

                $flight = $this->flights[$j];

                if (in_array($flight->id, $this->processedFlights))
                {
                    continue;
                }

                if ($this->currentLine->checkAndAddFlight($flight)){
//                    debug("{$i} ({$j}) - LINE: {$this->currentLine->getNum()} | Flight: STD:".getFlightDepartureDate($flight, false, true).
//                        " STA: ".getFlightArrivalDate($flight, false, true).
//                     "| First Flight Departure {$this->currentLine->getFirstFlightDeparture()}". "| Last Flight Arrival {$this->currentLine->getLastFlightArrival()}");

                    $this->processedFlights[] = $flight->id;

                    if ($flight->aircraft_id){
//                        debug($i."-".$j.") ".$flight->id." LINE ID: ".$this->currentLine->lineID);
                    }
                }

            }

            if ($this->currentLine->hasFlights()){
                $combine = false;

                foreach ($this->lines as $j => $line) {
//                    debug("----".$line->getNum());
                    if ($line->combineApplicable($this->currentLine, true)){

//                        debugFlights($line->getFlights(), $j, "BEFORE COMB");
//                        debug("First Flight Departure {$this->currentLine->getFirstFlightDeparture()}". "| Last Flight Arrival {$line->getLastFlightArrival()}");
                        $line->combineLine($this->currentLine);
                        $combine = true;
//                        debugFlights($line->getFlights(), $j, "AFTER COMB");
                        break;
                    }
                }
                if (!$combine){
                    $this->currentLine->num = ++$num;
                    $this->lines[] = $this->currentLine;
                }
//                debug("/***/ LINE: {$this->currentLine->getLineID()} | Flights: ". count($this->currentLine->getFlights()));
            }
        }


        foreach ($this->lines as $i => $line) {

            if ($line->getStatus() == DELETED){
                continue;
            }

            for ($j = $i + 1; $j < count($this->lines); $j++) {

                $otherLine = $this->lines[$j];

                if ($line->getNum() == $otherLine->getNum()){
                    continue;
                }

                if ($otherLine->getStatus() == DELETED){
                    continue;
                }

                if ($line->combineApplicable($otherLine)){
                    //debugFlights($line->getFlights(), $j, "BEFORE COMB");
                    //debug("First Flight Departure {$this->currentLine->getFirstFlightDeparture()}". "| Last Flight Arrival {$line->getLastFlightArrival()}");
                    $this->lines[$i]->combineLine($otherLine);

                    $this->lines[$j]->setStatus(DELETED);
                }
            }
        }

        foreach ($this->lines as $i => $line) {
            if ($line->getStatus() == DELETED){
                unset($this->lines[$i]);
            }
        }

//        debug($this->processedFlights);

        return;

        // Order by Station
        if ($this->lineType == HANDLING){
            usort($this->lines, array($this, "compareByStation"));

            // Update Num
            foreach ($this->lines as $i => &$each ) {
                $each->setNum($i);
            }
        }
    }




    /**
     * @var ILine $lineA
     * @var ILine $lineB
     * @return int
     */
    function compareByStation($lineA, $lineB)
    {
        if ($lineA->getAirlineID() == $lineB->getAirlineID()){
            return strcmp($lineA->getStation(), $lineB->getStation());
        }

        //return strcmp($lineA->getAirlineID(), $lineB->getAirlineID());
    }

    public function debugLines(){
        foreach ($this->lines as $line) {
            debugFlights($line->getFlights());
        }
    }


}
