<?php


namespace App\Classes\MatchFlights;

use App\Models\Flight;

class FlightLineH extends FlightLine implements ILine
{
    protected $stations;

    public function __construct($stations){
//        $this->lineID = rand(100, 999);
        $this->stations = $stations;
    }

    public function checkAndAddFlight($candidateFlight){

        $this->candidateFlight = $candidateFlight;

        // Flight fits
        if ($this->flightFits()){

            $this->addFlight();

            return true;
        }

        return false;
    }

    public function forceAddFlight($candidateFlight){

        $this->candidateFlight = $candidateFlight;

        // Flight fits
        $this->addFlight();

        return true;
    }

    public function combineApplicable(ILine $line, $aircraftMatchCheck = false){
        $lineFlight = $line->getFirstFlight();

        // Airline check
        if ($lineFlight->flightNumber->airline_id != $this->airline->id){
            return false;
        }

        if ($aircraftMatchCheck) {
            // IF Aircraft matches -> skip station match
            if ($this->firstFlight->aircraft_id && $lineFlight->aircraft_id) {
                if (!$this->checkAircraft($lineFlight)) {
                    return false;
                }
            }
            else {
                if ( !($this->stationMatches($line)
                    || $this->checkDepartureArrivalAirportsMatching($this->firstFlight, $lineFlight) )){
                    return false;
                }
//                else {
//                    debug("Line Flight: ".getFlightNumberFull($this->firstFlight->flightNumber)
//                        . " | Combine Line Flight ".getFlightNumberFull($lineFlight->flightNumber));
//                }
            }
        }
        else {
            if (!$this->stationMatches($line)){
                return false;
            }
        }

        if ($this->fitsBeforeFirstFlight($line->getLastFlight()) || $this->fitsAfterLastFlight($line->getFirstFlight())){
            return true;
        }

        return false;
    }

    function checkDepartureArrivalAirportsMatching($firstFlight, $secondFlight){
        return getFlightDepartureAirport($secondFlight) == getFlightArrivalAirport($firstFlight)
            && getFlightDepartureAirport($firstFlight) == getFlightArrivalAirport($secondFlight);

    }

    public function checkAircraft($flight){
        return $this->firstFlight->aircraft_id == $flight->aircraft_id;
    }

    function stationMatches(ILine $line){
        return $this->station == $line->getStation();
    }

    public function combineLine(ILine $line){

        // Combine in front
        if ($this->fitsBeforeFirstFlight($line->getLastFlight())){

            foreach ($line->getFlights() as $each) {
                $this->flights[] = $each;
            }

            $this->firstFlight = $line->getFirstFlight();
            $this->firstFlightDeparture = $line->getFirstFlightDeparture();

            return true;
        }
        elseif ($this->fitsAfterLastFlight($line->getFirstFlight())){

            foreach ($line->getFlights() as $each) {
                $this->flights[] = $each;
            }

            $this->lastFlight = $line->getLastFlight();
            $this->lastFlightArrival = $line->getLastFlightArrival();

            return true;
        }

        return false;
    }

    public function debugFlights(){
        $print = "LINE #".$this->num. " | ";
        foreach ($this->flights as $each) {
            if ($each->id == $this->firstFlight->id){
                $print .= "FIRST: ";

            }
            elseif ($each->id == $this->lastFlight->id){

                $print .= "LAST: ";
            }

            $print .= $each->flightNumber->flight_number." ("
                .getFlightDepartureDate($each, false, true)."-"
                .getFlightArrivalDate($each, false, true)."), ";
        }
        debug($print);
    }

    public function hasFlights(){
        return count($this->flights);
    }

    public function addFlight(){
        if (!$this->airline){
            $this->airline = $this->candidateFlight->flightNumber->airline;
        }

        $this->flights[] = $this->candidateFlight;

        $this->setFirstFlight();

        $this->setLastFlight();

        $this->setStation($this->candidateFlight);
    }

    function setStation($flight){
        if ($this->station){
            return;
        }

        $flightNumber = $flight->flightNumber;

        if (in_array($flightNumber->departure_airport_id, $this->stations)){
            $this->station = $flightNumber->departure_airport_id;
        }
        elseif (in_array($flightNumber->arrival_airport_id, $this->stations)) {
            $this->station = $flightNumber->arrival_airport_id;
        }
    }

    public function flightFits(){

        if (!count($this->flights)){
            return true;
        }

        if (in_array($this->candidateFlight, $this->flights)){
            return false;
        }

        if (!$this->candidateFlight->flightNumber){
            return false;
        }

        // Airline check
        if ($this->candidateFlight->flightNumber->airline_id != $this->airline->id){
            return false;
        }

//        if (!$this->checkFlightNumber()){
//            return false;
//        }

        if ($this->firstFlight->type == DEPARTURE){
            if ($this->candidateFlight->type == DEPARTURE
                || strtotime($this->candidateFlight->arr_datetime) > strtotime($this->firstFlight->dep_datetime)
            ){
                return false;
            }
        }
        elseif ($this->firstFlight->type == ARRIVAL){
            if ($this->candidateFlight->type == ARRIVAL
                || strtotime($this->candidateFlight->dep_datetime) < strtotime($this->firstFlight->arr_datetime)){
                return false;
            }
        }

        if (strtotime($this->candidateFlight->dep_datetime) - strtotime($this->lastFlight->arr_datetime) > 20 * 60 * 60
        || strtotime($this->firstFlight->dep_datetime) - strtotime($this->candidateFlight->arr_datetime) > 20 * 60 * 60){
            return false;
        }

        // IF AC EXISTS => mandatory to be in 1-line
        if ($this->firstFlight->aircraft_id && $this->candidateFlight->aircraft_id){
            if (!$this->checkAircraft($this->candidateFlight)) {
                return false;
            }
        }

        if (! ($this->fitsBeforeFirstFlight() || $this->fitsAfterLastFlight() || $this->fitsInTheMiddle())){
            return false;
        }

        if (!$this->firstFlight->aircraft_id && count($this->flights) == 1){
            if (!$this->checkDepartureArrivalAirportsMatching($this->candidateFlight, $this->firstFlight)){
                return false;
            }
        }
//        debug("All Match {$this->candidateFlight->id}");
//        debug("Current Flights ". $this->firstFlight->id);

        return true;
    }

    public function checkFlightNumber(){
        $candidateFN = intval($this->candidateFlight->flightNumber->flight_number);
        if (intval($this->firstFlight->flightNumber->flight_number) == $candidateFN ||
            intval($this->firstFlight->flightNumber->flight_number) - 1 == $candidateFN ||
            intval($this->lastFlight->flightNumber->flight_number) == $candidateFN ||
            intval($this->lastFlight->flightNumber->flight_number) + 1  == $candidateFN){

            return true;
        }

        return false;
    }

    public function fitsInTheMiddle(Flight $flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;

        $arrDate = getFlightArrivalDate($flight);
        $depDate = getFlightDepartureDate($flight);

        $arrAirportId = getFlightArrivalAirport($flight, true);
        $depAirportId = getFlightDepartureAirport($flight, true);

        $counter = count($this->flights);

        for ($i = 0; $i < $counter; $i++) {
            if ($i + 1 < $counter){
                $initFlt = $this->flights[$i + 1];
                $nextFlt = $this->flights[$i];
                $initFltArrAirportId = getFlightArrivalAirport($initFlt, true);
                $nextFltDepAirportId = getFlightDepartureAirport($nextFlt, true);

                if ($initFltArrAirportId != $nextFltDepAirportId &&
                    $initFltArrAirportId == $depAirportId  &&
                    $nextFltDepAirportId == $arrAirportId  &&
                    strtotime($depDate) > strtotime(getFlightArrivalDate($initFlt)) &&
                    strtotime($arrDate) < strtotime(getFlightDepartureDate($nextFlt))
                ){
                    return true;
                }
            }
        }

        return false;
    }

    public function fitsBeforeFirstFlight($flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;
        $flightArr = getFlightArrivalDate($flight);

        if ($this->firstFlight){
            if (strtotime($flightArr) > strtotime($this->firstFlightDeparture)
            ){
                return false;
            }

            $arrAirportId = getFlightArrivalAirport($flight, true);

            if (getFlightDepartureAirport($this->firstFlight, true) != $arrAirportId){
                return false;
            }
        }

        return true;
    }

    public function setFirstFlight(){
        if ($this->fitsBeforeFirstFlight()) {
            $this->firstFlight = $this->candidateFlight;
            $this->firstFlightDeparture = getFlightDepartureDate($this->candidateFlight);
        }
    }

    public function fitsAfterLastFlight($flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;
        $flightDep = getFlightDepartureDate($flight);

        if ($this->lastFlight){
            if (strtotime($flightDep) < strtotime($this->lastFlightArrival)){
                return false;
            }

            $depAirportId = getFlightDepartureAirport($flight, true);

            if (getFlightArrivalAirport($this->lastFlight, true) != $depAirportId){
                return false;
            }
        }

        return true;
    }

    public function setLastFlight(){
        if ($this->fitsAfterLastFlight()){
            $this->lastFlight = $this->candidateFlight;
            $this->lastFlightArrival = getFlightArrivalDate($this->candidateFlight);
        }
    }


}