<?php


namespace App\Classes\MatchFlights;

use App\Models\Flight;

class FlightLineA extends FlightLine implements ILine
{
    public function __construct($flight){
        $this->lineID = rand(100, 999);

        $this->checkAndAddFlight($flight);
    }

    public function checkAndAddFlight($candidateFlight){

        if (!$candidateFlight){
            return false;
        }

        $this->candidateFlight = $candidateFlight;

        // Flight fits
        if ($this->flightFits()){

            $this->addFlight();

            return true;
        }

        return false;
    }

    public function combineApplicable(ILine $line, $aircraftMatchCheck = false){
        // If aircraft exists
        if ($this->getAircraft() || $line->getAircraft()){
            if ($this->getAircraftID() == $line->getAircraftID()) {
//                debug("COMBINE PROCESS. LINE: ".$line->getLineID()." - to LINE: ".$this->getLineID());
                return true;
            }
            else {
                return false;
            }
        }

        if ($this->fitsBeforeFirstFlight($line->getLastFlight()) || $this->fitsAfterLastFlight($line->getFirstFlight())){
            return true;
        }

        return false;
    }

    function orderFlightsByDeparture(){
        if ( $this->flights && count( $this->flights)) {

            $list = $this->flights;
            // Sort
            usort($list, array($this, "compareByDeparture"));
            // Save
            $this->flights = $list;
        }
    }

    function compareByDeparture($flightA, $flightB)
    {
        return strcmp( strtotime(getFlightDepartureDate($flightA)), strtotime(getFlightDepartureDate($flightB)));
    }


    public function maintenanceFits($maintenance){

        if (!$this->aircraft){
            return false;
        }

        if ($this->aircraft->id != $maintenance->aircraft_id){
            return false;
        }

        return true;

        $start = strtotime($maintenance->arrival_time);
        $end = strtotime($maintenance->departure_time);

        // Order Flights
        $this->orderFlightsByDeparture();

        foreach ($this->flights as $i => $each) {
            $dep = getFlightDepartureDate($each);
            $arr = getFlightArrivalDate($each);

            if ($dep && $arr){
                if ($i == 0){
                    if ( $end < strtotime($dep)) {
                        debug("MAIN FITS DEP = ". $maintenance->departure_time. " FLT DEP:". $dep);
                        return true;
                    }
                }
                else {
                    if (!isset($this->flights[$i + 1])) {
                        if (strtotime($arr) < $start) {
                            return true;
                        }
                    } else {
                        $nextFlightDEP = getFlightDepartureDate($this->flights[$i + 1]);
                        $nextFlightARR = getFlightArrivalDate($this->flights[$i + 1]);

                        if ($nextFlightDEP && $nextFlightARR && strtotime($arr) < $start && $end < strtotime($nextFlightDEP)) {
                            return true;
                        }
                    }
                }
            }
        }

        return false;

    }


    public function combineLine(ILine $line){

        // Combine in front
        if ($this->fitsBeforeFirstFlight($line->getLastFlight())){

            foreach ($line->getFlights() as $each) {
                $this->flights[] = $each;
            }

            $this->firstFlight = $line->getFirstFlight();
            $this->firstFlightDeparture = $line->getFirstFlightDeparture();

            return true;
        }
        elseif ($this->fitsAfterLastFlight($line->getFirstFlight())){

            foreach ($line->getFlights() as $each) {
                $this->flights[] = $each;
            }

            $this->lastFlight = $line->getLastFlight();
            $this->lastFlightArrival = $line->getLastFlightArrival();

            return true;
        }
        else {
            foreach ($line->getFlights() as $each) {
                $this->flights[] = $each;
            }

            $this->lastFlight = $line->getLastFlight();
            $this->lastFlightArrival = $line->getLastFlightArrival();

            return true;
        }

        return false;
    }

    public function debugFlights(){
        $print = "LINE #".$this->num. " | ";
        foreach ($this->flights as $each) {
            if ($each->id == $this->firstFlight->id){
                $print .= "FIRST: ";

            }
            elseif ($each->id == $this->lastFlight->id){

                $print .= "LAST: ";
            }

            $print .= $each->flightNumber->flight_number." ("
                .getFlightDepartureDate($each, false, true)."-"
                .getFlightArrivalDate($each, false, true)."), ";
        }
        debug($print);
    }

    public function hasFlights(){
        return count($this->flights);
    }


    public function addFlight(){
        if (!$this->airline){
            $this->airline = $this->candidateFlight->flightNumber ? $this->candidateFlight->flightNumber->airline : null;
        }

        $this->flights[] = $this->candidateFlight;

        $this->setFirstFlight();

        $this->setLastFlight();
    }

    public function flightFits(){

        if (!count($this->flights)){
            return true;
        }

        if (in_array($this->candidateFlight, $this->flights)){
            return false;
        }

        if (!$this->candidateFlight->flightNumber){
            return false;
        }

        // IF AC EXISTS => mandatory to be in 1-line
        if (!$this->checkAircraft()) {
            return false;
        }

        if (!$this->checkAircraftType()) {
            return false;
        }

        if (!$this->checkFlightNumber()){
            return false;
        }


        $before = $after = $middle = false;
        if (! ($before = $this->fitsBeforeFirstFlight() || $after = $this->fitsAfterLastFlight() || $middle = $this->fitsInTheMiddle())){
            return false;
        }

//        if ($this->getNum() == 4) {
//            debug($this->getNum() . ". Var: {$before} / {$after} / {$middle} ");
//        }

        return true;
    }

    public function checkAircraft(){
        return $this->getAircraftID() == $this->candidateFlight->aircraft_id;
    }

    public function checkAircraftType(){
        return $this->firstFlight->aircraft_type_id == $this->candidateFlight->aircraft_type_id;
    }


    public function checkFlightNumber(){
        $candidateFN = $this->candidateFlight->flightNumber->flight_number;

        if ($this->firstFlight->flightNumber->flight_number == $candidateFN ||
            $this->firstFlight->flightNumber->flight_number - 1 == $candidateFN ||
            $this->lastFlight->flightNumber->flight_number == $candidateFN ||
            $this->lastFlight->flightNumber->flight_number + 1 == $candidateFN){

            return true;
        }

        return false;
    }

    public function fitsInTheMiddle(Flight $flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;

        $arrDate = getFlightArrivalDate($flight);
        $depDate = getFlightDepartureDate($flight);

        $arrAirportId = getFlightArrivalAirport($flight, true);
        $depAirportId = getFlightDepartureAirport($flight, true);

        $counter = count($this->flights);

        for ($i = 0; $i < $counter; $i++) {
            if ($i + 1 < $counter){
                $initFlt = $this->flights[$i + 1];
                $nextFlt = $this->flights[$i];
                $initFltArrAirportId = getFlightArrivalAirport($initFlt, true);
                $nextFltDepAirportId = getFlightDepartureAirport($nextFlt, true);

                if ($initFltArrAirportId != $nextFltDepAirportId &&
                    $initFltArrAirportId == $depAirportId  &&
                    $nextFltDepAirportId == $arrAirportId  &&
                    strtotime($depDate) > strtotime(getFlightArrivalDate($initFlt)) &&
                    strtotime($arrDate) < strtotime(getFlightDepartureDate($nextFlt))
                ){
                    return true;
                }
            }
        }

        return false;
    }

    public function fitsBeforeFirstFlight($flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;
        $flightArr = getFlightArrivalDate($flight);

        if ($this->firstFlight){
            if (strtotime($flightArr) >= strtotime($this->firstFlightDeparture)){
                return false;
            }

            $arrAirportId = getFlightArrivalAirport($flight, true);

            if (getFlightDepartureAirport($this->firstFlight, true) != $arrAirportId){
                return false;
            }
        }

        return true;
    }

    public function setFirstFlight(){
        if ($this->fitsBeforeFirstFlight()) {
            $this->firstFlight = $this->candidateFlight;
            $this->firstFlightDeparture = getFlightDepartureDate($this->candidateFlight);

            $this->setAircraft();
        }
    }

    public function setAircraft(){
        $this->aircraft = $this->candidateFlight->aircraft;
    }


    public function fitsAfterLastFlight($flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;
        $flightDep = getFlightDepartureDate($flight);

        if ($this->lastFlight){
            if (strtotime($flightDep) <= strtotime($this->lastFlightArrival)){
                return false;
            }

            $depAirportId = getFlightDepartureAirport($flight, true);

            if (getFlightArrivalAirport($this->lastFlight, true) != $depAirportId){
                return false;
            }
        }

        return true;
    }

    public function setLastFlight(){
        if ($this->fitsAfterLastFlight()){
            $this->lastFlight = $this->candidateFlight;
            $this->lastFlightArrival = getFlightArrivalDate($this->candidateFlight);
        }
    }
}