<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */

namespace App\Classes\Flight;


class FlightStandby extends FlightProperties implements IFlight
{
    // 30 Minutes after the departure
     protected $standbyFlightOffset = 1800;

    public function setStartDuty(){
        $this->startDuty = $this->flight->std;
    }

    public function setEndDuty(){
        $this->endDuty = date("Y-m-d H:i", strtotime($this->flight->std) + $this->standbyFlightOffset);
    }

    public function setFlightTime(){
        $this->flightTime = 0;
        $this->flight->flight_time = $this->flightTime;
    }

    public function setFlyingTime(){
        $this->flyingTime = 0;
        $this->flight->flying_time = $this->flyingTime;
    }

    public function setOtherTime(){
        $this->otherTime = Calculate_Duration($this->startDuty, $this->endDuty);
        $this->flight->other_time = $this->otherTime;
    }

    public function setReportTime($reportTimeOffset){
        $this->reportTime = date('Y-m-d H:i', strtotime($this->startDuty) - $reportTimeOffset);
    }

    public function setReleaseTime($releaseTimeOffset){
        $this->releaseTime = date('Y-m-d H:i', strtotime($this->endDuty));
    }

    /**
     * Check If This Flight Before Given Flight
     * @param $flight
     * @return bool
     */
    public function checkIfBeforeFlight($flight){
        if (strtotime($this->flight->std) < strtotime($flight->std))
            return true;
        else
            return false;
    }

    /**
     * Check If This Flight After Given Flight
     * @param $flight
     * @return bool
     */
    public function checkIfAfterFlight($flight){
        if (strtotime($this->endDuty) > strtotime($flight->endDuty)) // prev. STA
            return true;
        else
            return false;
    }
}
