<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */

namespace App\Classes\Flight;


class FlightRegular extends FlightProperties implements IFlight
{
    public function setStartDuty(){
        $this->startDuty = $this->flight->std;
    }

    public function setEndDuty(){
        $this->endDuty = $this->flight->sta;
    }

    public function setFlightTime(){
        if ($this->flight->atd && $this->flight->ata) {
            $this->flightTime = Calculate_Duration($this->flight->atd, $this->flight->ata);
        }
        else {
            $this->flightTime = Calculate_Duration($this->flight->std, $this->flight->sta);
        }
        $this->flight->flight_time = $this->flightTime;
    }

    public function setFlyingTime(){
        $this->flyingTime = 0;
        if ($this->flight->abn && $this->flight->tdn){
            $this->flyingTime = Calculate_Duration($this->flight->abn, $this->flight->tdn);
        }
        $this->flight->flying_time = $this->flyingTime;
    }

    public function setOtherTime($hours = 0){
        $this->otherTime = $hours;
    }

    public function setReportTime($reportTimeOffset){
        $this->reportTime = date('Y-m-d H:i', strtotime($this->startDuty) - $reportTimeOffset);
    }

    public function setReleaseTime($releaseTimeOffset){
        $this->releaseTime = date('Y-m-d H:i', strtotime($this->endDuty) + $releaseTimeOffset);
    }

    /**
     * Check If This Flight Before Given Flight
     * @param $flight
     * @return bool
     */
    public function checkIfBeforeFlight($flight){
        if (strtotime($this->flight->std) < strtotime($flight->std))
            return true;
        else
            return false;
    }

    /**
     * Check If This Flight After Given Flight
     * @param $flight
     * @return bool
     */
    public function checkIfAfterFlight($flight){
        if (strtotime($this->flight->sta) > strtotime($flight->sta))
            return true;
        else
            return false;
    }


}
