<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */

namespace App\Classes\Flight;


abstract class FlightProperties
{

    protected $flight;

    // Start Duty Will Match Departure Time
    protected $startDuty;

    // For Standby Flights' End Duty Will be 30m after the departure
    // End Duty Will Match Arrival Time For Other Flight Types
    protected $endDuty;

    protected $flightTime;

    protected $flyingTime;

    protected $otherTime;

    protected $reportTime;

    protected $releaseTime;

    public function __construct($flight, $reportTimeOffset, $releaseTimeOffset){

        $this->flight = $flight;

        $this->setStartDuty();

        $this->setEndDuty();

        $this->setFlightTime();

        $this->setFlyingTime();

        $this->setOtherTime();

        $this->setReportTime($reportTimeOffset);

        $this->setReleaseTime($releaseTimeOffset);
    }

    abstract public function setStartDuty();
    abstract public function setEndDuty();
    abstract public function setFlightTime();
    abstract public function setFlyingTime();
    abstract public function setOtherTime();
    abstract public function setReportTime($reportTimeOffset);
    abstract public function setReleaseTime($releaseTimeOffset);

    public function setFlights($flights){
        $this->flights = $flights;
    }

    public function getFlight(){
        return $this->flight;
    }

    public function getDeparture(){
        return $this->flight->std;
    }

    public function getArrival(){
        return $this->flight->sta;
    }

    public function getFlightTime(){
        return $this->flightTime;
    }

    public function getFlyingTime(){
        return $this->flyingTime;
    }

    public function getOtherTime(){
        return $this->otherTime;
    }

    public function getReportTime(){
        return $this->reportTime;
    }

    public function getReleaseTime(){
        return $this->releaseTime;
    }

    public function getEndDuty(){
        return $this->endDuty;
    }

}
