<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */

namespace App\Classes\Crew;


use App\Classes\Flight\FlightDhc;
use App\Classes\Flight\FlightRegular;
use App\Classes\Flight\FlightStandby;

abstract class CrewProperties
{
    protected $rosterLaw = TAJIKISTAN_CAA;

    protected $localTime = 18000;    // Local Time +/- FROM GMT (in secs)

    protected $fdpList = [];

    // + minutes which is added To Flights std (default = 1H:15M before first flight)
    protected $reportTimeOffset = 3600; // 4500;

    // + minutes which is added To Flights sta (default = 0H:30M after last flight)
    protected $releaseTimeOffset = 1800;

    protected $crewBaseAirports = [];


    protected $orderFlights = ORDER_DESC;

    function setCrewBaseAirports($locationRepository){
        $locations = $locationRepository->get(['airport']);
        foreach ($locations as $each) {
            $this->crewBaseAirports[] = $each->airport->iata;
        }

    }

    public function addFlights($flights){
        foreach ($flights as $flight) {
            // Determine What Kind of flight it is
            $newFlight = $this->determineFlightTypeAndAdd($flight);
            $found = false;
            if (count($this->fdpList)){
                foreach ($this->fdpList as $fdp) {
                    if ($fdp->checkAndAddFlight($newFlight)){
                        $found = true;
                        break;
                    }
                }
            }
            if (!$found)
                $this->fdpList[] = new FDP($newFlight,
                                           $this->reportTimeOffset,
                                           $this->releaseTimeOffset,
                                           $this->crewBaseAirports,
                                           $this->orderFlights);
        }
    }

    public function getFdpList(){
        return $this->fdpList;
    }

    function determineFlightTypeAndAdd($flight){
        if ($flight->is_standby){
            $newFlight = new FlightStandby($flight, $this->reportTimeOffset, $this->releaseTimeOffset);
        }
        elseif ($flight->is_dhc){
            $newFlight = new FlightDhc($flight, $this->reportTimeOffset, $this->releaseTimeOffset);
        }
        else{
            $newFlight = new FlightRegular($flight, $this->reportTimeOffset, $this->releaseTimeOffset);
        }
        return $newFlight;
    }

    public function debugFdpList(){
        foreach ($this->fdpList as $fdp) {
//            $fdp->debugDetails();
        }
    }
}
