<?php namespace App\Classes;
use App\Models\Flight;

/**
 * Created by PhpStorm.

 */

abstract class Crew {
    const HOUR_RESTRICTION = 'HOUR_RESTRICTION';
    const LAST_7_DAYS = 'LAST_7_DAYS';
    const LAST_28_DAYS = 'LAST_28_DAYS';
    const LAST_12_MONTHS = 'LAST_12_MONTHS';

    const FDP_LAST_7_DAYS = 'FDP_LAST_7_DAYS';
    const FDP_LAST_28_DAYS = 'FDP_LAST_28_DAYS';

    public $id;
    public $pseudo_crew = false;
    public $last_name;
    public $first_name;
    public $hour_restriction;
    public $start_eligible = FALSE;
    public $eligible = FALSE;
    public $base;
    public $current_location;
    public $different_hub_first_date;
    public $dhc_count = 0;
    public $standby_count = 0;
    public $planned_hours = 0;
    public $duty_hours_28 = 0;

    public $block_hours_7 = 0;
    public $block_hours_28 = 0;
    public $block_hours_12months = 0;

    public $fdp_hours_7 = 0;
    public $fdp_hours_28 = 0;

    public $flight_hours_date = [];         // Array of date & hours
    public $flight_history = [];
    public $unavailable_periods = [];
    public $designated_flights = [];
    public $designated_rest_period = [];
    public $details;
    public $schedule = [];


    public function Set_Designated_Flights($grouped_flights){
        $this->designated_flights[] = $grouped_flights;
        $last_flight = $grouped_flights[count($grouped_flights) - 1];
        $flight1 = Flight::find($grouped_flights[0],['std']);
        $flight2 = Flight::find($last_flight,['sta']);
        $this->designated_rest_period[] = ['from' => Add_Minutes_To_DateTime($flight1->std, 12, 'hours', 'subtract'),
            'to' => Add_Minutes_To_DateTime($flight2->sta, 12, 'hours')];
    }

    public function Add_Flight_Hours($block_hours, $departure_date){
        $date = date('Y-m-d', strtotime($departure_date));
        if (isset($this->flight_hours_date[$date])){
            $this->flight_hours_date[$date] += $block_hours;
        }
        else {
            $this->flight_hours_date[$date] = $block_hours;
        }
    }

    public function Add_Sector_Count($flights){
        foreach ($flights as $flight) {
            $sector = $flight['departure_airport'].'-'.$flight['arrival_airport'];
            if (isset($this->flight_history[$sector])) {
                $this->flight_history[$sector]++;
            } else {
                $this->flight_history[$sector] = 1;
            }
        }
    }

    public function Count_Block_Hours($departure_date, $label, $limit_hours = null, $new_fdp_total_hours = null){
        $date = date('Y-m-d', strtotime($departure_date));
        $total_hours = 0;
        $new_fdp_total_hours = isset($new_fdp_total_hours) ? $new_fdp_total_hours : 0;
        switch ($label){
            case self::HOUR_RESTRICTION :
                $last_28_days = date('Y-m-d', strtotime("$date - 28 days"));
                foreach ($this->flight_hours_date as $j=>$each){
                    if (strtotime($j) >= strtotime($last_28_days) && strtotime($j) <= strtotime($date)){
                        $total_hours += $each;
                    }
                }
                if (isset($this->hour_restriction)){
                    if ($total_hours + $new_fdp_total_hours >= $this->hour_restriction)
                        $this->eligible = false;
                    else
                        $this->eligible = true;
                }
                break;
            case self::LAST_7_DAYS :
                $last_7_days = date('Y-m-d', strtotime("$date - 7 days"));
                foreach ($this->flight_hours_date as $j=>$each){
                    if (strtotime($j) >= strtotime($last_7_days) && strtotime($j) <= strtotime($date)){
                        $total_hours += $each;
                    }
                }
                $this->block_hours_7 = $total_hours;
                if (isset($limit_hours)){
                    if ($total_hours + $new_fdp_total_hours >= $limit_hours)
                        $this->eligible = false;
                    else
                        $this->eligible = true;
                }
                break;
            case self::LAST_28_DAYS :
                $last_28_days = date('Y-m-d', strtotime("$date - 28 days"));
                foreach ($this->flight_hours_date as $j=>$each){
                    if (strtotime($j) >= strtotime($last_28_days) && strtotime($j) <= strtotime($date)){
                        $total_hours += $each;
                    }
                }
                $this->block_hours_28 = $total_hours;
                if (isset($limit_hours)){
                    if ($total_hours + $new_fdp_total_hours >= $limit_hours)
                        $this->eligible = false;
                    else
                        $this->eligible = true;
                }
                break;

            case self::LAST_12_MONTHS :
                $last_12_months = date('Y-m-d', strtotime("$date - 12 months"));
                foreach ($this->flight_hours_date as $j=>$each){
                    if (strtotime($j) >= strtotime($last_12_months) && strtotime($j) <= strtotime($date)){
                        $total_hours += $each;
                    }
                }
                $this->block_hours_12months = $total_hours;
                if (isset($limit_hours)){
                    if ($total_hours + $new_fdp_total_hours >= $limit_hours)
                        $this->eligible = false;
                    else
                        $this->eligible = true;
                }
                break;

            case self::FDP_LAST_7_DAYS :
                $last_7_days = date('Y-m-d', strtotime("$date - 7 days"));

                foreach ($this->schedule as $j => $each){
                    $reportTime = date('Y-m-d', strtotime($each->report_time));
                    if (strtotime($reportTime) >= strtotime($last_7_days) && strtotime($reportTime) <= strtotime($date)){
                        $total_hours += $each->fdp_cumulative;
                    }
                }

                $this->fdp_hours_7 = $total_hours;

                if (isset($limit_hours)){
                    if ($total_hours + $new_fdp_total_hours >= $limit_hours)
                        $this->eligible = false;
                    else
                        $this->eligible = true;
                }
                break;

            case self::FDP_LAST_28_DAYS :
                $last_28_days = date('Y-m-d', strtotime("$date - 28 days"));

                foreach ($this->schedule as $j => $each){
                    $reportTime = date('Y-m-d', strtotime($each->report_time));
                    if (strtotime($reportTime) >= strtotime($last_28_days) && strtotime($reportTime) <= strtotime($date)){
                        $total_hours += $each->fdp_cumulative;
                    }
                }

                $this->fdp_hours_28 = $total_hours;

                if (isset($limit_hours)){
                    if ($total_hours + $new_fdp_total_hours >= $limit_hours)
                        $this->eligible = false;
                    else
                        $this->eligible = true;
                }
                break;
        }
        return $total_hours;
    }


}
