<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 19.06.17

 */

namespace App\Classes\BindFlights;

use App\Models\Airport;

class FlightPosition
{
    public $date;

    public $strict = false;

    protected $stations = [];

    protected $flights = [];

    protected $maintenance = [];

    /** @var  ILine */
    protected $currentLine;

    /** @var ILine[] $lines */
    public $lines = [];

    protected $lineType;

    protected $processedFlights = [];

    public function __construct($flights, $maintenance = []){

        // For Airline Module Sort By A/C and A/C type
        if (env(CARRIER) == AIRLINE){

            $this->flights = $flights->sortBy("aircraft_id")
                                        ->sortBy('aircraft_type_id')
                                        ->values()
                                        ->all();

        }
        else {
            $this->stations = Airport::getHandlingStations();

            $this->flights = $flights->sortBy("airline_id")
                                    ->sortBy('std')
                                    ->sortBy('ptd')
                                    ->sortBy('atd')
                                    ->values();
        }

        $this->maintenance = $maintenance;

        $this->setLineType();
    }

    function setLineType(){
        if (env("CARRIER") == HANDLING){
            $this->lineType = HANDLING;
        }
        else{
           $this->lineType = AIRLINE;
        }
    }

    function createNewLine(){
        if ($this->lineType == HANDLING){
            return new FlightLineH($this->stations);
        }
        else {
            return new FlightLineA();
        }

    }

    public function run(){

        $num = 0;

        debug("TOTAL: ".count($this->flights). " flights");

        $handlingStations = Airport::getHandlingStationsIdAndObject();

        foreach ($this->flights as $i => &$each) {
            $each->type = getFlightsDepArrType($each, $handlingStations);
            $each->dep_datetime = getFlightDepartureInitialDate($each);
            $each->dep_date = date("Y-m-d", strtotime($each->dep_datetime));

            $each->arr_datetime = getFlightArrivalInitialDate($each);
            $each->arr_date = date("Y-m-d", strtotime($each->arr_datetime));
        }

        foreach ($this->flights as $i => &$each) {

            if ($each->type == DEPARTURE && strtotime($each->dep_date) < strtotime($this->date)){
                continue;
            }

            $this->currentLine = $this->createNewLine();

            foreach ($this->flights as $j => $flight) {

                if (in_array($flight->id, $this->processedFlights)
                    || ($flight->type == DEPARTURE && strtotime($flight->dep_date) < strtotime($this->date)))
                {
                    continue;
                }

                if (count($this->currentLine->getFlights()) < 2 && $this->currentLine->checkAndAddFlight($flight)){
//                    debug("{$i} ({$j}) - LINE: {$this->currentLine->getNum()} | Flight: STD:".getFlightDepartureDate($flight, false, true).
//                        " STA: ".getFlightArrivalDate($flight, false, true).
//                     "| First Flight Departure {$this->currentLine->getFirstFlightDeparture()}". "| Last Flight Arrival {$this->currentLine->getLastFlightArrival()}");

                    $this->processedFlights[] = $flight->id;
                }
            }

            if ($this->currentLine->hasFlights()) {

                $combine = false;

                if (count($this->currentLine->getFlights()) == 1) {
                    foreach ($this->lines as $j => $line) {

                        if (count($line->getFlights()) > 1) {
                            continue;
                        }

                        if ($line->combineApplicable($this->currentLine, $this->strict)) {

//                        debugFlights($line->getFlights(), $j, "BEFORE COMB");
//                        debug("First Flight Departure {$this->currentLine->getFirstFlightDeparture()}". "| Last Flight Arrival {$line->getLastFlightArrival()}");
                            $line->combineLine($this->currentLine);
                            $combine = true;
//                            debugFlights($line->getFlights(), $j, "AFTER COMB");
                            break;
                        }
                    }
                }

                if (!$combine) {
                    $this->currentLine->num = ++$num;
                    $this->lines[] = $this->currentLine;
                }
            }
//                debug("{$i} - LINE: {$this->currentLine->getNum()} | Flights: ". count($this->currentLine->getFlights()));
        }

        $newLines = [];

        /*
        foreach ($this->maintenance as $each) {

            $combine = false;
            foreach ($this->lines as $j => $line) {
                if ($line->maintenanceFits($each)){

                    $line->addMaintenance($each);

                    $combine = true;
                    break;
                }
            }

            if (!$combine){
                $this->currentLine = $this->createNewLine();
                $this->currentLine->addMaintenance($each);
                $this->lines[] = $this->currentLine;
            }
        }
    */

        foreach ($newLines as $each) {
            $this->lines[] = $each;
        }

        // Order by Station
        if ($this->lineType == HANDLING){
            usort($this->lines, array($this, "compareByStation"));

            // Update Num
            foreach ($this->lines as $i => &$each ) {
                $each->setNum($i);
            }
        }

    }

    /**
     * @var ILine $lineA
     * @var ILine $lineB
     * @return int
     */
    function compareByStation($lineA, $lineB)
    {

        if ($lineA->getAirlineID() == $lineB->getAirlineID()){
            return strcmp($lineA->getStation(), $lineB->getStation());
        }

        return strcmp($lineA->getAirlineID(), $lineB->getAirlineID());
    }

    public function debugLines(){
        foreach ($this->lines as $line) {
            debugFlights($line->getFlights());
        }
    }


}
