<?php


namespace App\Classes\BindFlights;

use App\Models\Flight;

class FlightLineH extends FlightLine implements ILine
{
    protected $stations;

    public function __construct($stations){
        $this->stations = $stations;
    }


    public function checkAndAddFlight($candidateFlight){

        $this->candidateFlight = $candidateFlight;

        // Flight fits
        if ($this->flightFits()){

            $this->addFlight();

            return true;
        }

        return false;
    }

    public function combineApplicable(ILine $line, $strict = false){
        $lineFirstFlight = $line->getFirstFlight();
        $lineLastFlight = $line->getLastFlight();

        // Airline check
        if ($lineFirstFlight->flightNumber->airline_id != $this->airline->id){
            return false;
        }

        if (!$this->stationMatches($line)){
            return false;
        }

        if ($this->firstFlight->type == DEPARTURE){
            if ($lineFirstFlight->type == DEPARTURE || strtotime($lineFirstFlight->arr_datetime) > strtotime($this->firstFlight->dep_datetime)){
                return false;
            }
        }
        elseif ($this->firstFlight->type == ARRIVAL){
            if ($lineFirstFlight->type == ARRIVAL || strtotime($lineFirstFlight->dep_datetime) < strtotime($this->firstFlight->arr_datetime)){
                return false;
            }
        }

        // IF AC EXISTS => mandatory to be in 1-line
//        if ($this->firstFlight->aircraft_id){
            if (!$this->checkAircraft($lineFirstFlight) && !$this->checkFlightNumber($lineFirstFlight)){
                return false;
            }
//        }

        if ($strict){
            if ($this->fitsBeforeFirstFlight($lineLastFlight)){
                if (!$this->checkDepartureArrivalAirportsMatching($lineLastFlight, $this->firstFlight)){
                    return false;
                }
            }

            if ($this->fitsAfterLastFlight($lineLastFlight)){
                if (!$this->checkDepartureArrivalAirportsMatching($this->lastFlight, $lineFirstFlight)){
                    return false;
                }
            }
        }

        if ($this->fitsBeforeFirstFlight($lineLastFlight) || $this->fitsAfterLastFlight($lineFirstFlight)){
            return true;
        }

        return false;
    }

    function checkDepartureArrivalAirportsMatching($firstFlight, $secondFlight){
        return getFlightDepartureAirport($secondFlight) == getFlightArrivalAirport($firstFlight)
            && getFlightDepartureAirport($firstFlight) == getFlightArrivalAirport($secondFlight);

    }

    function stationMatches(ILine $line){
        return $this->station == $line->getStation();
    }

    public function combineLine(ILine $line){

        // Combine in front
        if ($this->fitsBeforeFirstFlight($line->getLastFlight())){

            foreach ($line->getFlights() as $each) {
                $this->flights[] = $each;
            }

            $this->firstFlight = $line->getFirstFlight();
            $this->firstFlightDeparture = $line->getFirstFlightDeparture();

            return true;
        }
        elseif ($this->fitsAfterLastFlight($line->getFirstFlight())){

            foreach ($line->getFlights() as $each) {
                $this->flights[] = $each;
            }

            $this->lastFlight = $line->getLastFlight();
            $this->lastFlightArrival = $line->getLastFlightArrival();

            return true;
        }

        return false;
    }

    public function debugFlights(){
        $print = "LINE #".$this->num. " | ";
        foreach ($this->flights as $each) {
            if ($each->id == $this->firstFlight->id){
                $print .= "FIRST: ";

            }
            elseif ($each->id == $this->lastFlight->id){

                $print .= "LAST: ";
            }

            $print .= $each->flightNumber->flight_number." ("
                .getFlightDepartureInitialDate($each, false, true)."-"
                .getFlightArrivalInitialDate($each, false, true)."), ";
        }
        debug($print);
    }

    public function hasFlights(){
        return count($this->flights);
    }

    public function addFlight(){
        if (!$this->airline){
            $this->airline = $this->candidateFlight->flightNumber->airline;
        }

        $this->flights[] = $this->candidateFlight;

        $this->setFirstFlight();

        $this->setLastFlight();

        $this->setStation($this->candidateFlight);
    }

    function setStation($flight){
        if ($this->station){
            return;
        }

        $flightNumber = $flight->flightNumber;

        if (in_array($flightNumber->departure_airport_id, $this->stations)){
            $this->station = $flightNumber->departure_airport_id;
        }
        elseif (in_array($flightNumber->arrival_airport_id, $this->stations)) {
            $this->station = $flightNumber->arrival_airport_id;
        }
    }

    public function flightFits(){

        if (!count($this->flights)){
            return true;
        }

        if (in_array($this->candidateFlight, $this->flights)){
            return false;
        }

        if (!$this->candidateFlight->flightNumber){
            return false;
        }

        // Airline check
        if ($this->candidateFlight->flightNumber->airline_id != $this->airline->id){
            return false;
        }

        if (!$this->checkFlightNumber($this->candidateFlight)){
            return false;
        }

        //
        if ($this->firstFlight->type == DEPARTURE){
            if ($this->candidateFlight->type == DEPARTURE
                || strtotime($this->candidateFlight->arr_datetime) > strtotime($this->firstFlight->dep_datetime)){
                return false;
            }
        }
        elseif ($this->firstFlight->type == ARRIVAL){
            if ($this->candidateFlight->type == ARRIVAL
                || strtotime($this->candidateFlight->dep_datetime) < strtotime($this->firstFlight->arr_datetime)){
                return false;
            }
        }

        // IF AC EXISTS => mandatory to be in 1-line
        if ($this->firstFlight->aircraft_id){
            if (!$this->checkAircraft($this->candidateFlight)) {
                return false;
            }
        }

        if ($this->fitsBeforeFirstFlight() || $this->fitsAfterLastFlight()){ // || $this->fitsInTheMiddle())){

            if($this->candidateFlight->flightNumber->flight_number == "3409D"){
                debug("MATCHED");
            }

            return true;

        }

        return false;
    }

    public function checkAircraft($flight){
        return $this->firstFlight->aircraft_id == $flight->aircraft_id;
    }

    public function checkFlightNumber($flight){
        $candidateFN = intval($flight->flightNumber->flight_number);

        if (intval($this->firstFlight->flightNumber->flight_number) == $candidateFN ||
            intval($this->firstFlight->flightNumber->flight_number) - 1 == $candidateFN ||
            intval($this->lastFlight->flightNumber->flight_number) == $candidateFN ||
            intval($this->lastFlight->flightNumber->flight_number) + 1  == $candidateFN){

            return true;
        }
        return false;
    }

    public function fitsInTheMiddle(Flight $flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;

        $arrDate = getFlightArrivalInitialDate($flight);
        $depDate = getFlightDepartureInitialDate($flight);

        $arrAirportId = getFlightArrivalAirport($flight, true);
        $depAirportId = getFlightDepartureAirport($flight, true);

        $counter = count($this->flights);

        for ($i = 0; $i < $counter; $i++) {
            if ($i + 1 < $counter){
                $initFlt = $this->flights[$i + 1];
                $nextFlt = $this->flights[$i];
                $initFltArrAirportId = getFlightArrivalAirport($initFlt, true);
                $nextFltDepAirportId = getFlightDepartureAirport($nextFlt, true);

                if ($initFltArrAirportId != $nextFltDepAirportId &&
                    $initFltArrAirportId == $depAirportId  &&
                    $nextFltDepAirportId == $arrAirportId  &&
                    strtotime($depDate) > strtotime(getFlightArrivalInitialDate($initFlt)) &&
                    strtotime($arrDate) < strtotime(getFlightDepartureInitialDate($nextFlt))
                ){
                    return true;
                }
            }
        }

        return false;
    }

    public function fitsBeforeFirstFlight($flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;
        $flightArr = getFlightArrivalInitialDate($flight);

        if ($this->firstFlight){

            if (strtotime($flightArr) > strtotime($this->firstFlightDeparture)
                || (strtotime($flightArr) + 10 * 60 * 60  < strtotime($this->firstFlightDeparture))){
                return false;
            }

            if($flight->flightNumber->flight_number == "3409D"){
                debug($flight->flightNumber->flight_number);
                debug($this->firstFlight->flightNumber->flight_number);
                debug($this->firstFlight->flightNumber->flight_number == $flight->flightNumber->flight_number);
            }

            // Check if both flights nos are same => then match
            if ($flight->flightNumber->flight_number == $this->firstFlight->flightNumber->flight_number){
                return true;
            }

            $arrAirportId = getFlightArrivalAirport($flight, true);

            if (getFlightDepartureAirport($this->firstFlight, true) != $arrAirportId){
                return false;
            }
        }

        return true;
    }

    public function setFirstFlight(){
        if ($this->fitsBeforeFirstFlight()) {
            $this->firstFlight = $this->candidateFlight;
            $this->firstFlightDeparture = getFlightDepartureInitialDate($this->candidateFlight);
        }
    }

    public function fitsAfterLastFlight($flight = null){
        $flight = $flight ? $flight : $this->candidateFlight;
        $flightDep = getFlightDepartureInitialDate($flight);

        if ($this->lastFlight){


            if (strtotime($flightDep) < strtotime($this->lastFlightArrival)
                || (strtotime($flightDep) - 10 * 60 * 60  > strtotime($this->lastFlightArrival))){
                return false;
            }

            $depAirportId = getFlightDepartureAirport($flight, true);

            if (getFlightArrivalAirport($this->lastFlight, true) != $depAirportId){
                return false;
            }
        }

        return true;
    }

    public function setLastFlight(){
        if ($this->fitsAfterLastFlight()){
            $this->lastFlight = $this->candidateFlight;
            $this->lastFlightArrival = getFlightArrivalInitialDate($this->candidateFlight);
        }
    }


}