<?php


namespace App\Classes\BindFlights;

use App\Models\Flight;

class FlightLine
{
    public $num;

    protected $aircraft;

    protected $airline;

    protected $station;

    protected $candidateFlight;

    protected $firstFlight;

    protected $firstFlightDeparture;

    protected $lastFlight;

    protected $lastFlightArrival;

    protected $flights = [];

    protected $maintenance = [];

    public function maintenanceFits($maintenance){
        return false;
    }

    public function addMaintenance($maintenance){
        $this->maintenance[] = $maintenance;
    }

    public function setNum($num){
        $this->num = $num;
    }

    public function getStation(){
        return $this->station;
    }

    public function getAircraft(){
        return $this->aircraft;
    }

    public function getAirline(){
        return $this->airline;
    }

    public function getAirlineID(){
        return $this->airline ? $this->airline->id : null;
    }

    public function getNum(){
        return $this->num;
    }

    public function getFlights(){
        return $this->flights;
    }

     public function getMaintenance(){
        return $this->maintenance;
    }

    public function getFirstFlight(){
        return $this->firstFlight;
    }

    public function getLastFlight(){
        return $this->lastFlight;
    }

    public function getFirstFlightDeparture(){
        return $this->firstFlightDeparture;
    }

    public function getLastFlightArrival(){
        return $this->lastFlightArrival;
    }

}